/*
 * Decompiled with CFR 0.152.
 */
package nxt.crypto;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.junit.Assert;
import org.junit.Test;

public class SecureRandomTest {
    @Test
    public void simpleSecureRandom() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] byArray = new byte[32];
        for (int i = 0; i < 30; ++i) {
            secureRandom.nextBytes(byArray);
        }
    }

    @Test
    public void sha1prngSecureRandom() {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            byte[] byArray = new byte[32];
            for (int i = 0; i < 30; ++i) {
                secureRandom.nextBytes(byArray);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.fail((String)noSuchAlgorithmException.getMessage());
        }
    }

    @Test
    public void strongSecureRandom() {
        try {
            SecureRandom secureRandom = SecureRandom.getInstanceStrong();
            byte[] byArray = new byte[32];
            for (int i = 0; i < 30; ++i) {
                secureRandom.nextBytes(byArray);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Assert.fail((String)noSuchAlgorithmException.getMessage());
        }
    }

    @Test
    public void reproducibleRandom() throws NoSuchAlgorithmException {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        long l = 12345678L;
        secureRandom.setSeed(l);
        Assert.assertEquals((long)3325995872096263519L, (long)secureRandom.nextLong());
        System.out.println(secureRandom.nextLong());
        SecureRandom secureRandom2 = SecureRandom.getInstance("SHA1PRNG");
        secureRandom2.setSeed(l);
        Assert.assertEquals((long)3325995872096263519L, (long)secureRandom2.nextLong());
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        new SecureRandomTest().simpleSecureRandom();
        System.out.println("simpleSecureRandom:" + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        new SecureRandomTest().sha1prngSecureRandom();
        System.out.println("sha1prngSecureRandom:" + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        new SecureRandomTest().strongSecureRandom();
        System.out.println("strongSecureRandom:" + (System.currentTimeMillis() - l));
    }
}

