/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nxt.http.APIRemoteConnector;
import org.junit.Assert;
import org.junit.Test;

public class APIRemoteConnectorTest {
    @Test
    public void testParamsToQueryString() {
        Assert.assertEquals((Object)"", (Object)APIRemoteConnector.paramsToQueryString(Collections.emptyMap()));
        Assert.assertEquals((Object)"key=val", (Object)APIRemoteConnector.paramsToQueryString(Collections.singletonMap("key", Collections.singletonList("val"))));
        Assert.assertEquals((Object)"key=val1&key=val2", (Object)APIRemoteConnector.paramsToQueryString(Collections.singletonMap("key", Arrays.asList("val1", "val2"))));
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("key1", Collections.singletonList("val1"));
        linkedHashMap.put("key2", Collections.singletonList("val2"));
        Assert.assertEquals((Object)"key1=val1&key2=val2", (Object)APIRemoteConnector.paramsToQueryString(linkedHashMap));
        linkedHashMap = new LinkedHashMap();
        linkedHashMap.put("key1", Stream.of("val1", "val2").collect(Collectors.toList()));
        linkedHashMap.put("key2", Collections.singletonList("val3"));
        linkedHashMap.put("key3", Stream.of("val4", "val5", "val6").collect(Collectors.toList()));
        Assert.assertEquals((Object)"key1=val1&key1=val2&key2=val3&key3=val4&key3=val5&key3=val6", (Object)APIRemoteConnector.paramsToQueryString(linkedHashMap));
    }
}

