/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import nxt.BlockchainTest;
import nxt.account.Account;
import nxt.crypto.EncryptedData;
import nxt.http.JSONResponses;
import nxt.util.Convert;
import org.json.simple.JSONStreamAware;
import org.junit.Assert;
import org.junit.Test;

public class MessageEncryptionTest
extends BlockchainTest {
    @Test
    public void encryptBytes() {
        byte[] byArray = new byte[]{1, 2, -15, -14};
        EncryptedData encryptedData = this.encrypt(byArray);
        Assert.assertArrayEquals((byte[])byArray, (byte[])this.decrypt(encryptedData));
    }

    @Test
    public void encryptText() {
        JSONStreamAware jSONStreamAware = JSONResponses.INCORRECT_ALIAS;
        EncryptedData encryptedData = this.encrypt(Convert.toBytes((String)jSONStreamAware.toString()));
        Assert.assertEquals((Object)jSONStreamAware.toString(), (Object)Convert.toString((byte[])this.decrypt(encryptedData)));
    }

    @Test
    public void encryptEmpty() {
        EncryptedData encryptedData = this.encrypt(Convert.toBytes((String)""));
        Assert.assertEquals((Object)"", (Object)Convert.toString((byte[])this.decrypt(encryptedData)));
    }

    private EncryptedData encrypt(byte[] byArray) {
        Account account = Account.getAccount((byte[])BOB.getPublicKey());
        if (account == null) {
            throw new IllegalStateException();
        }
        return account.encryptTo(byArray, ALICE.getSecretPhrase(), false);
    }

    private byte[] decrypt(EncryptedData encryptedData) {
        Account account = ALICE.getAccount();
        return account.decryptFrom(encryptedData, BOB.getSecretPhrase(), false);
    }
}

