/*
 * Decompiled with CFR 0.152.
 */
package nxt.http;

import java.util.Collections;
import nxt.BlockchainTest;
import nxt.account.Account;
import nxt.blockchain.ChildChain;
import nxt.crypto.Crypto;
import nxt.crypto.EncryptedData;
import nxt.http.APICall;
import nxt.util.Convert;
import nxt.util.JSONAssert;
import nxt.util.Logger;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class SendMessageTest
extends BlockchainTest {
    public static final String NON_EXISTENT_ACCOUNT_SECRET = "NonExistentAccount.jkgdkjgdjkfgfkjgfjkdfgkjjdk";

    @Test
    public void sendMessage() {
        JSONObject jSONObject = new APICall.Builder("sendMessage").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("message", "hello world").param("feeNQT", ChildChain.IGNIS.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMessage: " + jSONObject));
        String string = (String)jSONObject.get((Object)"fullHash");
        JSONObject jSONObject2 = (JSONObject)((JSONObject)jSONObject.get((Object)"transactionJSON")).get((Object)"attachment");
        Assert.assertEquals((Object)"hello world", (Object)jSONObject2.get((Object)"message"));
        SendMessageTest.generateBlock();
        jSONObject = new APICall.Builder("readMessage").param("secretPhrase", BOB.getSecretPhrase()).param("transactionFullHash", string).build().invoke();
        Logger.logDebugMessage((String)("readMessage: " + jSONObject));
        Assert.assertEquals((Object)"hello world", (Object)jSONObject.get((Object)"message"));
    }

    @Test
    public void sendEncryptedMessage() {
        JSONObject jSONObject = new APICall.Builder("sendMessage").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("messageToEncrypt", "hello world").param("feeNQT", ChildChain.IGNIS.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMessage: " + jSONObject));
        String string = (String)jSONObject.get((Object)"fullHash");
        JSONObject jSONObject2 = (JSONObject)((JSONObject)jSONObject.get((Object)"transactionJSON")).get((Object)"attachment");
        JSONObject jSONObject3 = (JSONObject)jSONObject2.get((Object)"encryptedMessage");
        Assert.assertNotEquals((long)64L, (long)((String)jSONObject3.get((Object)"data")).length());
        Assert.assertNotEquals((long)32L, (long)((String)jSONObject3.get((Object)"nonce")).length());
        SendMessageTest.generateBlock();
        jSONObject = new APICall.Builder("readMessage").param("secretPhrase", BOB.getSecretPhrase()).param("transactionFullHash", string).build().invoke();
        Logger.logDebugMessage((String)("readMessage: " + jSONObject));
        Assert.assertEquals((Object)"hello world", (Object)jSONObject.get((Object)"decryptedMessage"));
    }

    @Test
    public void sendClientEncryptedMessage() {
        EncryptedData encryptedData = BOB.getAccount().encryptTo(Convert.toBytes((String)"hello world"), ALICE.getSecretPhrase(), true);
        JSONObject jSONObject = new APICall.Builder("sendMessage").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("encryptedMessageData", Convert.toHexString((byte[])encryptedData.getData())).param("encryptedMessageNonce", Convert.toHexString((byte[])encryptedData.getNonce())).param("feeNQT", ChildChain.IGNIS.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMessage: " + jSONObject));
        String string = (String)jSONObject.get((Object)"fullHash");
        JSONObject jSONObject2 = (JSONObject)((JSONObject)jSONObject.get((Object)"transactionJSON")).get((Object)"attachment");
        JSONObject jSONObject3 = (JSONObject)jSONObject2.get((Object)"encryptedMessage");
        Assert.assertNotEquals((long)64L, (long)((String)jSONObject3.get((Object)"data")).length());
        Assert.assertNotEquals((long)32L, (long)((String)jSONObject3.get((Object)"nonce")).length());
        SendMessageTest.generateBlock();
        jSONObject = new APICall.Builder("readMessage").param("secretPhrase", BOB.getSecretPhrase()).param("transactionFullHash", string).build().invoke();
        Logger.logDebugMessage((String)("readMessage: " + jSONObject));
        Assert.assertEquals((Object)"hello world", (Object)jSONObject.get((Object)"decryptedMessage"));
    }

    @Test
    public void sendEncryptedMessageToSelf() {
        JSONObject jSONObject = new APICall.Builder("sendMessage").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("messageToEncryptToSelf", "hello world").param("feeNQT", ChildChain.IGNIS.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMessage: " + jSONObject));
        String string = (String)jSONObject.get((Object)"fullHash");
        JSONObject jSONObject2 = (JSONObject)((JSONObject)jSONObject.get((Object)"transactionJSON")).get((Object)"attachment");
        JSONObject jSONObject3 = (JSONObject)jSONObject2.get((Object)"encryptToSelfMessage");
        Assert.assertNotEquals((long)64L, (long)((String)jSONObject3.get((Object)"data")).length());
        Assert.assertNotEquals((long)32L, (long)((String)jSONObject3.get((Object)"nonce")).length());
        SendMessageTest.generateBlock();
        jSONObject = new APICall.Builder("readMessage").param("secretPhrase", ALICE.getSecretPhrase()).param("transactionFullHash", string).build().invoke();
        Logger.logDebugMessage((String)("readMessage: " + jSONObject));
        Assert.assertEquals((Object)"hello world", (Object)jSONObject.get((Object)"decryptedMessageToSelf"));
    }

    @Test
    public void sendClientEncryptedMessageToSelf() {
        EncryptedData encryptedData = ALICE.getAccount().encryptTo(Convert.toBytes((String)"hello world"), ALICE.getSecretPhrase(), true);
        JSONObject jSONObject = new APICall.Builder("sendMessage").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).param("encryptToSelfMessageData", Convert.toHexString((byte[])encryptedData.getData())).param("encryptToSelfMessageNonce", Convert.toHexString((byte[])encryptedData.getNonce())).param("feeNQT", ChildChain.IGNIS.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMessage: " + jSONObject));
        String string = (String)jSONObject.get((Object)"fullHash");
        JSONObject jSONObject2 = (JSONObject)((JSONObject)jSONObject.get((Object)"transactionJSON")).get((Object)"attachment");
        JSONObject jSONObject3 = (JSONObject)jSONObject2.get((Object)"encryptToSelfMessage");
        Assert.assertEquals((long)96L, (long)((String)jSONObject3.get((Object)"data")).length());
        Assert.assertEquals((long)64L, (long)((String)jSONObject3.get((Object)"nonce")).length());
        SendMessageTest.generateBlock();
        jSONObject = new APICall.Builder("readMessage").param("secretPhrase", ALICE.getSecretPhrase()).param("transactionFullHash", string).build().invoke();
        Logger.logDebugMessage((String)("readMessage: " + jSONObject));
        Assert.assertEquals((Object)"hello world", (Object)jSONObject.get((Object)"decryptedMessageToSelf"));
    }

    @Test
    public void publicKeyAnnouncement() {
        byte[] byArray = Crypto.getPublicKey((String)NON_EXISTENT_ACCOUNT_SECRET);
        String string = Convert.toHexString((byte[])byArray);
        long l = Account.getId((byte[])byArray);
        String string2 = Convert.rsAccount((long)l);
        JSONObject jSONObject = new APICall.Builder("getAccount").param("account", string2).build().invoke();
        Logger.logDebugMessage((String)("getAccount: " + jSONObject));
        Assert.assertEquals((Object)5L, (Object)jSONObject.get((Object)"errorCode"));
        jSONObject = new APICall.Builder("sendMessage").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", string2).param("recipientPublicKey", string).param("feeNQT", ChildChain.IGNIS.ONE_COIN).build().invoke();
        Logger.logDebugMessage((String)("sendMessage: " + jSONObject));
        SendMessageTest.generateBlock();
        jSONObject = new APICall.Builder("getAccount").param("account", string2).build().invoke();
        Logger.logDebugMessage((String)("getAccount: " + jSONObject));
        Assert.assertEquals((Object)string, (Object)jSONObject.get((Object)"publicKey"));
    }

    @Test
    public void sendFromNotExistingAccount() {
        APICall.Builder builder = new APICall.Builder("sendMessage").param("secretPhrase", NON_EXISTENT_ACCOUNT_SECRET).param("message", "hello world").param("recipient", ALICE.getRsAccount()).feeNQT(ChildChain.IGNIS.ONE_COIN);
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        Assert.assertEquals((Object)"Not enough funds", (Object)jSONAssert.str("errorDescription"));
        builder.feeNQT(0L);
        jSONAssert = new JSONAssert(builder.build().invoke());
        SendMessageTest.bundleTransactions(Collections.singletonList(jSONAssert.fullHash()));
        SendMessageTest.generateBlock();
    }
}

