/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.accountControl;

import java.util.Arrays;
import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.crypto.HashFunction;
import nxt.http.APICall;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class ACTestUtils {
    public static void assertNoPhasingOnlyControl() {
        APICall.Builder builder = new APICall.Builder("getPhasingOnlyControl").param("account", Long.toUnsignedString(BlockchainTest.ALICE.getId()));
        JSONObject jSONObject = builder.build().invoke();
        Assert.assertTrue((boolean)jSONObject.isEmpty());
    }

    public static JSONObject assertTransactionSuccess(APICall.Builder builder) {
        JSONObject jSONObject = builder.build().invoke();
        Logger.logMessage((String)(builder.getParam("requestType") + " response: " + jSONObject.toJSONString()));
        Assert.assertNull((Object)jSONObject.get((Object)"error"));
        String string = (String)jSONObject.get((Object)"fullHash");
        Assert.assertNotNull((Object)string);
        return jSONObject;
    }

    public static void assertTransactionBlocked(APICall.Builder builder) {
        JSONObject jSONObject = builder.build().invoke();
        Logger.logMessage((String)(builder.getParam("requestType") + " response: " + jSONObject.toJSONString()));
        String string = (String)jSONObject.get((Object)"error");
        Assert.assertNotNull((String)"Transaction should fail, but didn't", (Object)string);
        Assert.assertTrue((boolean)string.contains("nxt.NxtException$AccountControlException"));
    }

    public static long getAccountBalance(long l, String string) {
        APICall.Builder builder = new APICall.Builder("getBalance").param("account", Long.toUnsignedString(l));
        JSONObject jSONObject = builder.build().invoke();
        Logger.logMessage((String)("getBalance response: " + jSONObject.toJSONString()));
        return Long.parseLong((String)jSONObject.get((Object)string));
    }

    public static void setControlPhasingParams(APICall.Builder builder, VoteWeighting.VotingModel votingModel, String string, Long l, Long l2, VoteWeighting.MinBalanceModel minBalanceModel, long[] lArray, long l3, int n, int n2) {
        ACTestUtils.setControlPhasingParams(builder, "", votingModel, string, l, l2, minBalanceModel, lArray, l3, n, n2);
    }

    public static void setControlPhasingParams(APICall.Builder builder, String string, VoteWeighting.VotingModel votingModel, String string2, Long l, Long l2, VoteWeighting.MinBalanceModel minBalanceModel, long[] lArray, long l3, int n, int n2) {
        if (votingModel != null) {
            builder.param("control" + string + "VotingModel", votingModel.getCode());
        }
        if (string2 != null) {
            builder.param("control" + string + "Holding", string2);
        }
        if (l != null) {
            builder.param("control" + string + "Quorum", l.longValue());
        }
        if (l2 != null) {
            builder.param("control" + string + "MinBalance", l2.longValue());
        }
        if (minBalanceModel != null) {
            builder.param("control" + string + "MinBalanceModel", minBalanceModel.getCode());
        }
        if (lArray != null) {
            builder.param("control" + string + "Whitelisted", (String[])Arrays.stream(lArray).mapToObj(Long::toUnsignedString).toArray(String[]::new));
        }
        if (string.isEmpty() && l3 >= 0L) {
            builder.param("controlMaxFees", ChildChain.IGNIS.getId() + ":" + l3);
        }
        if (string.isEmpty() && n > 0) {
            builder.param("controlMinDuration", n);
        }
        if (string.isEmpty() && n2 > 0) {
            builder.param("controlMaxDuration", n2);
        }
    }

    public static JSONObject approve(Object object, Tester tester, String string) {
        JSONObject jSONObject = ACTestUtils.approveBuilder(object, tester, string).build().invoke();
        Assert.assertNull((Object)jSONObject.get((Object)"errorCode"));
        return jSONObject;
    }

    public static APICall.Builder approveBuilder(Object object, Tester tester, String string) {
        APICall.Builder builder = new APICall.Builder("approveTransaction").param("secretPhrase", tester.getSecretPhrase()).param("revealedSecretText", string).param("feeNQT", ChildChain.IGNIS.ONE_COIN);
        if (object != null) {
            builder = builder.param("phasedTransaction", ChildChain.IGNIS.getId() + ":" + object);
        }
        return builder;
    }

    public static PhasingStatus getPhasingStatus(Object object) {
        JSONObject jSONObject = new APICall.Builder("getPhasingPoll").param("transactionFullHash", (String)object).param("countVotes", "true").build().invoke();
        Object object2 = jSONObject.get((Object)"approved");
        if (object2 != null) {
            if (Boolean.TRUE.equals(object2)) {
                return PhasingStatus.APPROVED;
            }
            return PhasingStatus.REJECTED;
        }
        Long l = (Long)jSONObject.get((Object)"finishHeight");
        if (l != null) {
            return PhasingStatus.PENDING;
        }
        return PhasingStatus.NONE;
    }

    public static enum PhasingStatus {
        NONE,
        PENDING,
        REJECTED,
        APPROVED;

    }

    public static class AssetBuilder
    extends APICall.Builder {
        public AssetBuilder(String string, String string2) {
            super("issueAsset");
            this.param("name", string2);
            this.param("description", "Unit tests asset");
            this.param("quantityQNT", 10000);
            this.param("decimals", 4);
            this.secretPhrase(string);
            this.feeNQT(1000L * ChildChain.IGNIS.ONE_COIN);
        }
    }

    public static class CurrencyExchangeBuilder
    extends APICall.Builder {
        public CurrencyExchangeBuilder(String string, String string2, int n) {
            super("publishExchangeOffer");
            this.param("currency", string);
            this.param("buyRateNQTPerUnit", 10L * ChildChain.IGNIS.ONE_COIN);
            this.param("sellRateNQTPerUnit", 10L * ChildChain.IGNIS.ONE_COIN);
            this.param("totalBuyLimit", 0);
            this.param("totalSellLimit", 50);
            this.param("initialBuySupply", 0);
            this.param("initialSellSupply", 5);
            this.param("expirationHeight", n);
            this.secretPhrase(string2);
            this.feeNQT(ChildChain.IGNIS.ONE_COIN);
        }
    }

    public static class CurrencyBuilder
    extends TestCurrencyIssuance.Builder {
        public CurrencyBuilder() {
            this.params.remove("minReservePerUnitNQT");
            this.params.remove("minDifficulty");
            this.params.remove("maxDifficulty");
            this.params.remove("algorithm");
        }
    }

    public static class PhasingBuilder
    extends Builder {
        private boolean isBuildingControl;
        private String currentSubPollName = "";

        public PhasingBuilder(Tester tester) {
            this("setPhasingOnlyControl", tester);
        }

        public PhasingBuilder(String string, Tester tester) {
            super(string, tester.getSecretPhrase());
            boolean bl = this.isBuildingControl = "setPhasingOnlyControl".equals(string) || "setPhasingAssetControl".equals(string);
            if (!this.isBuildingControl) {
                this.startPhasingParams();
            }
        }

        public PhasingBuilder startPhasingParams() {
            this.param("phased", "true").param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + 5);
            this.isBuildingControl = false;
            this.currentSubPollName = "";
            return this;
        }

        public PhasingBuilder startSubPoll(String string) {
            this.setParamValidation(false);
            this.currentSubPollName = string;
            return this;
        }

        public PhasingBuilder votingModel(VoteWeighting.VotingModel votingModel) {
            this.param(this.getPrefix() + "VotingModel", votingModel.getCode());
            return this;
        }

        public PhasingBuilder quorum(int n) {
            this.param(this.getPrefix() + "Quorum", n);
            return this;
        }

        public PhasingBuilder quorum(long l) {
            this.param(this.getPrefix() + "Quorum", l);
            return this;
        }

        public PhasingBuilder whitelist(Tester ... testerArray) {
            this.param(this.getPrefix() + "Whitelisted", (String[])Arrays.stream(testerArray).map(Tester::getStrId).toArray(String[]::new));
            return this;
        }

        public PhasingBuilder hashedSecret(String string, HashFunction hashFunction) {
            this.param(this.getPrefix() + "HashedSecretAlgorithm", hashFunction.getId());
            this.param(this.getPrefix() + "HashedSecret", Convert.toHexString((byte[])hashFunction.hash(string.getBytes())));
            return this;
        }

        public PhasingBuilder property(String string, Tester tester, String string2, String string3) {
            this.phasingParam(string + "PropertySetter", tester.getStrId());
            this.phasingParam(string + "PropertyName", string2);
            this.phasingParam(string + "PropertyValue", string3);
            return this;
        }

        public PhasingBuilder phasingParam(String string, String string2) {
            this.param(this.getPrefix() + string, string2);
            return this;
        }

        private String getPrefix() {
            return (this.isBuildingControl ? "control" : "phasing") + this.currentSubPollName;
        }
    }

    public static class Builder
    extends APICall.Builder {
        public Builder(String string, String string2) {
            super(string);
            this.secretPhrase(string2);
            this.feeNQT(ChildChain.IGNIS.ONE_COIN);
        }
    }
}

