/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.accountControl;

import java.util.Arrays;
import java.util.Collections;
import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.accountControl.ACTestUtils;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.http.twophased.TestPropertyVoting;
import nxt.util.Convert;
import nxt.util.JSONAssert;
import nxt.util.Logger;
import nxt.voting.PhasingParams;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class PhasingOnlyTest
extends BlockchainTest {
    @Test
    public void testSetAndGet() {
        ACTestUtils.assertNoPhasingOnlyControl();
        PhasingOnlyTest.setPhasingOnlyControl(VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId()}, 10L * ChildChain.IGNIS.ONE_COIN, 5, 1440);
        this.assertPhasingOnly(new PhasingParams(new VoteWeighting(VoteWeighting.VotingModel.ACCOUNT.getCode(), 0L, 0L, 0), 1L, new long[]{BOB.getId()}, Collections.emptyList(), null, null, null, null), this.buildMaxFeesJSON(ChildChain.IGNIS.getId(), 10L * ChildChain.IGNIS.ONE_COIN), 5, 1440);
    }

    @Test
    public void testAccountVoting() {
        PhasingOnlyTest.setPhasingOnlyControl(VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId(), CHUCK.getId()}, -1L, 0, 0);
        APICall.Builder builder = new ACTestUtils.Builder("sendMoney", ALICE.getSecretPhrase()).recipient(BOB.getId()).param("amountNQT", ChildChain.IGNIS.ONE_COIN);
        ACTestUtils.assertTransactionBlocked(builder);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId(), CHUCK.getId()});
        ACTestUtils.assertTransactionSuccess(builder);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId()});
        ACTestUtils.assertTransactionBlocked(builder);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.ACCOUNT, null, 2L, null, null, new long[]{BOB.getId(), CHUCK.getId()});
        ACTestUtils.assertTransactionBlocked(builder);
        builder = new ACTestUtils.Builder("setPhasingOnlyControl", ALICE.getSecretPhrase());
        ACTestUtils.setControlPhasingParams(builder, VoteWeighting.VotingModel.NONE, null, null, null, null, null, -1L, 0, 0);
        this.setTransactionPhasingParams(builder, 3, VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId(), CHUCK.getId()});
        JSONObject jSONObject = ACTestUtils.assertTransactionSuccess(builder);
        PhasingOnlyTest.generateBlock();
        this.assertPhasingOnly(new PhasingParams(new VoteWeighting(VoteWeighting.VotingModel.ACCOUNT.getCode(), 0L, 0L, 0), 1L, new long[]{BOB.getId(), CHUCK.getId()}, Collections.emptyList(), null, null, null, null), new JSONObject(), 0, 0);
        builder = new ACTestUtils.Builder("approveTransaction", BOB.getSecretPhrase()).param("phasedTransaction", this.getPhasedTransaction(jSONObject));
        ACTestUtils.assertTransactionSuccess(builder);
        PhasingOnlyTest.generateBlock();
        ACTestUtils.assertNoPhasingOnlyControl();
    }

    @Test
    public void testExtraRestrictions() {
        PhasingOnlyTest.setPhasingOnlyControl(VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId(), CHUCK.getId()}, 5L * ChildChain.IGNIS.ONE_COIN, 4, 100);
        APICall.Builder builder = new ACTestUtils.Builder("sendMoney", ALICE.getSecretPhrase()).recipient(BOB.getId()).param("amountNQT", ChildChain.IGNIS.ONE_COIN).feeNQT(7L * ChildChain.IGNIS.ONE_COIN);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId(), CHUCK.getId()});
        ACTestUtils.assertTransactionBlocked(builder);
        builder.feeNQT(5L * ChildChain.IGNIS.ONE_COIN);
        JSONObject jSONObject = ACTestUtils.assertTransactionSuccess(builder);
        PhasingOnlyTest.generateBlock();
        ACTestUtils.assertTransactionBlocked(builder);
        APICall.Builder builder2 = new ACTestUtils.Builder("approveTransaction", BOB.getSecretPhrase()).param("phasedTransaction", this.getPhasedTransaction(jSONObject));
        ACTestUtils.assertTransactionSuccess(builder2);
        PhasingOnlyTest.generateBlock();
        jSONObject = ACTestUtils.assertTransactionSuccess(builder);
        String string = this.getPhasedTransaction(jSONObject);
        PhasingOnlyTest.generateBlock();
        builder2.param("phasedTransaction", string);
        ACTestUtils.assertTransactionSuccess(builder2);
        PhasingOnlyTest.generateBlock();
        builder.param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + 200);
        ACTestUtils.assertTransactionBlocked(builder);
        builder.param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + 3);
        ACTestUtils.assertTransactionBlocked(builder);
        builder.param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + 4);
        ACTestUtils.assertTransactionSuccess(builder);
    }

    @Test
    public void testRejectingPendingTransaction() {
        long l = ChildChain.IGNIS.ONE_COIN;
        APICall.Builder builder = new ACTestUtils.Builder("sendMoney", ALICE.getSecretPhrase()).recipient(BOB.getId()).param("amountNQT", l);
        this.setTransactionPhasingParams(builder, 4, VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId(), CHUCK.getId()});
        JSONObject jSONObject = ACTestUtils.assertTransactionSuccess(builder);
        PhasingOnlyTest.generateBlock();
        builder = new ACTestUtils.Builder("setPhasingOnlyControl", ALICE.getSecretPhrase());
        ACTestUtils.setControlPhasingParams(builder, VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{DAVE.getId()}, -1L, 0, 0);
        ACTestUtils.assertTransactionSuccess(builder);
        PhasingOnlyTest.generateBlock();
        long l2 = ACTestUtils.getAccountBalance(BOB.getId(), "unconfirmedBalanceNQT");
        builder = new ACTestUtils.Builder("approveTransaction", CHUCK.getSecretPhrase()).param("phasedTransaction", this.getPhasedTransaction(jSONObject));
        ACTestUtils.assertTransactionSuccess(builder);
        PhasingOnlyTest.generateBlock();
        PhasingOnlyTest.generateBlock();
        Assert.assertEquals((long)(l2 + l), (long)ACTestUtils.getAccountBalance(BOB.getId(), "unconfirmedBalanceNQT"));
    }

    @Test
    public void testBalanceVoting() {
        PhasingOnlyTest.setPhasingOnlyControl(VoteWeighting.VotingModel.COIN, "2", 100L * ChildChain.IGNIS.ONE_COIN, null, null, null, -1L, 0, 0);
        APICall.Builder builder = new ACTestUtils.Builder("sendMoney", ALICE.getSecretPhrase()).recipient(BOB.getId()).param("amountNQT", ChildChain.IGNIS.ONE_COIN);
        ACTestUtils.assertTransactionBlocked(builder);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.COIN, "2", 100L * ChildChain.IGNIS.ONE_COIN, null, null, new long[]{DAVE.getId()});
        ACTestUtils.assertTransactionBlocked(builder);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId(), CHUCK.getId()});
        ACTestUtils.assertTransactionBlocked(builder);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.COIN, "2", 100L * ChildChain.IGNIS.ONE_COIN + 1L, null, null, null);
        ACTestUtils.assertTransactionBlocked(builder);
        builder = new ACTestUtils.Builder("sendMoney", ALICE.getSecretPhrase()).recipient(BOB.getId()).param("amountNQT", ChildChain.IGNIS.ONE_COIN);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.COIN, "2", 100L * ChildChain.IGNIS.ONE_COIN, null, null, null);
        ACTestUtils.assertTransactionSuccess(builder);
    }

    @Test
    public void testAssetVoting() {
        ACTestUtils.AssetBuilder assetBuilder = new ACTestUtils.AssetBuilder(ALICE.getSecretPhrase(), "TestAsset");
        String string = Tester.responseToStringId(ACTestUtils.assertTransactionSuccess(assetBuilder));
        PhasingOnlyTest.generateBlock();
        assetBuilder = new ACTestUtils.AssetBuilder(ALICE.getSecretPhrase(), "TestAsset2");
        String string2 = Tester.responseToStringId(ACTestUtils.assertTransactionSuccess(assetBuilder));
        PhasingOnlyTest.generateBlock();
        PhasingOnlyTest.setPhasingOnlyControl(VoteWeighting.VotingModel.ASSET, string, 100L, null, null, null, -1L, 0, 0);
        assetBuilder = new ACTestUtils.Builder("sendMoney", ALICE.getSecretPhrase()).recipient(BOB.getId()).param("amountNQT", ChildChain.IGNIS.ONE_COIN);
        ACTestUtils.assertTransactionBlocked(assetBuilder);
        this.setTransactionPhasingParams(assetBuilder, 20, VoteWeighting.VotingModel.ASSET, string2, 100L, null, null, null);
        ACTestUtils.assertTransactionBlocked(assetBuilder);
        this.setTransactionPhasingParams(assetBuilder, 20, VoteWeighting.VotingModel.ASSET, string, 100L, null, null, null);
        ACTestUtils.assertTransactionSuccess(assetBuilder);
    }

    @Test
    public void testCurrencyVoting() {
        TestCurrencyIssuance.Builder builder = new ACTestUtils.CurrencyBuilder().naming("fgsha", "FGSHA", "Test AC");
        String string = Tester.responseToStringId(ACTestUtils.assertTransactionSuccess(builder));
        PhasingOnlyTest.generateBlock();
        builder = new ACTestUtils.CurrencyBuilder().naming("fgshb", "FGSHB", "Test AC");
        String string2 = Tester.responseToStringId(ACTestUtils.assertTransactionSuccess(builder));
        PhasingOnlyTest.generateBlock();
        PhasingOnlyTest.setPhasingOnlyControl(VoteWeighting.VotingModel.CURRENCY, string, 100L, null, null, null, -1L, 0, 0);
        builder = new ACTestUtils.Builder("sendMoney", ALICE.getSecretPhrase()).recipient(BOB.getId()).param("amountNQT", ChildChain.IGNIS.ONE_COIN);
        ACTestUtils.assertTransactionBlocked(builder);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.CURRENCY, string2, 100L, null, null, null);
        ACTestUtils.assertTransactionBlocked(builder);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.CURRENCY, string, 100L, null, null, null);
        ACTestUtils.assertTransactionSuccess(builder);
    }

    @Test
    public void testPropertyVoting() {
        ACTestUtils.Builder builder = new ACTestUtils.Builder("setPhasingOnlyControl", ALICE.getSecretPhrase());
        ACTestUtils.setControlPhasingParams(builder, VoteWeighting.VotingModel.PROPERTY, null, 1L, 0L, VoteWeighting.MinBalanceModel.NONE, null, -1L, 0, 0);
        String string = "propac1";
        String string2 = "prop_val";
        builder.param("controlSenderPropertySetter", CHUCK.getStrId());
        builder.param("controlSenderPropertyName", string);
        builder.param("controlSenderPropertyValue", string2);
        new JSONAssert(builder.build().invoke()).str("fullHash");
        PhasingOnlyTest.generateBlock();
        builder = TestPropertyVoting.createGenericBuilder();
        builder.param("phasingSenderPropertySetter", CHUCK.getStrId());
        builder.param("phasingSenderPropertyName", string);
        builder.param("phasingSenderPropertyValue", string2 + "a");
        new JSONAssert(builder.build().invoke()).str("errorDescription");
        builder.param("phasingSenderPropertyValue", string2);
        builder.param("phasingSenderPropertySetter", BOB.getStrId());
        new JSONAssert(builder.build().invoke()).str("errorDescription");
        builder.param("phasingSenderPropertySetter", CHUCK.getStrId());
        new JSONAssert(builder.build().invoke()).str("fullHash");
        PhasingOnlyTest.generateBlock();
    }

    @Test
    public void testZeroMaxFees() {
        ACTestUtils.Builder builder = new ACTestUtils.Builder("setPhasingOnlyControl", ALICE.getSecretPhrase());
        ACTestUtils.setControlPhasingParams(builder, VoteWeighting.VotingModel.ACCOUNT, null, 1L, 0L, VoteWeighting.MinBalanceModel.NONE, new long[]{BOB.getId()}, 0L, 0, 0);
        new JSONAssert(builder.build().invoke()).str("fullHash");
        PhasingOnlyTest.generateBlock();
        long l = ChildChain.IGNIS.ONE_COIN;
        builder = new ACTestUtils.Builder("sendMoney", ALICE.getSecretPhrase()).recipient(CHUCK.getId()).param("amountNQT", l).feeNQT(1L);
        this.setTransactionPhasingParams(builder, 20, VoteWeighting.VotingModel.ACCOUNT, null, 1L, null, null, new long[]{BOB.getId()});
        ACTestUtils.assertTransactionBlocked(builder);
        builder.feeNQT(0L);
        String string = new JSONAssert(ACTestUtils.assertTransactionSuccess(builder)).fullHash();
        PhasingOnlyTest.bundleTransactions(Collections.singletonList(string));
        PhasingOnlyTest.generateBlock();
        ACTestUtils.approve(string, BOB, null);
        PhasingOnlyTest.generateBlock();
        Assert.assertEquals((long)l, (long)CHUCK.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    private void assertPhasingOnly(PhasingParams phasingParams, JSONObject jSONObject, int n, int n2) {
        APICall.Builder builder = new APICall.Builder("getPhasingOnlyControl").param("account", Long.toUnsignedString(ALICE.getId()));
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        JSONAssert jSONAssert2 = jSONAssert.subObj("controlParams");
        Assert.assertEquals((long)phasingParams.getVoteWeighting().getVotingModel().getCode(), (long)Long.valueOf(jSONAssert2.integer("phasingVotingModel")).byteValue());
        Assert.assertEquals((long)phasingParams.getQuorum(), (long)Convert.parseLong((Object)jSONAssert2.str("phasingQuorum")));
        Assert.assertEquals((long)phasingParams.getWhitelist().length, (long)jSONAssert2.array("phasingWhitelist", String.class).size());
        Assert.assertEquals((long)phasingParams.getVoteWeighting().getHoldingId(), (long)Convert.parseUnsignedLong((String)jSONAssert2.str("phasingHolding")));
        Assert.assertEquals((long)phasingParams.getVoteWeighting().getMinBalance(), (long)Convert.parseLong((Object)jSONAssert2.str("phasingMinBalance")));
        Assert.assertEquals((long)phasingParams.getVoteWeighting().getMinBalanceModel().getCode(), (long)Long.valueOf(jSONAssert2.integer("phasingVotingModel")).byteValue());
        Assert.assertEquals((Object)jSONObject, (Object)jSONAssert.subObj("maxFees").getJson());
        Assert.assertEquals((long)n, (long)jSONAssert.integer("minDuration"));
        Assert.assertEquals((long)n2, (long)jSONAssert.integer("maxDuration"));
    }

    public static void setPhasingOnlyControl(VoteWeighting.VotingModel votingModel, String string, Long l, Long l2, VoteWeighting.MinBalanceModel minBalanceModel, long[] lArray, long l3, int n, int n2) {
        ACTestUtils.Builder builder = new ACTestUtils.Builder("setPhasingOnlyControl", ALICE.getSecretPhrase());
        ACTestUtils.setControlPhasingParams(builder, votingModel, string, l, l2, minBalanceModel, lArray, l3, n, n2);
        APICall aPICall = builder.build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("setPhasingOnlyControl response: " + jSONObject.toJSONString()));
        String string2 = (String)jSONObject.get((Object)"fullHash");
        Assert.assertNotNull((Object)string2);
        PhasingOnlyTest.generateBlock();
    }

    private void setTransactionPhasingParams(APICall.Builder builder, int n, VoteWeighting.VotingModel votingModel, String string, Long l, Long l2, VoteWeighting.MinBalanceModel minBalanceModel, long[] lArray) {
        builder.param("phased", "true");
        builder.param("phasingVotingModel", votingModel.getCode());
        builder.param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + n);
        builder.param("phasingHolding", string);
        if (l != null) {
            builder.param("phasingQuorum", l.longValue());
        }
        if (l2 != null) {
            builder.param("phasingMinBalance", l2.longValue());
        }
        if (minBalanceModel != null) {
            builder.param("phasingMinBalanceModel", minBalanceModel.getCode());
        }
        if (lArray != null) {
            builder.param("phasingWhitelisted", (String[])Arrays.stream(lArray).mapToObj(Long::toUnsignedString).toArray(String[]::new));
        }
    }

    private String getPhasedTransaction(JSONObject jSONObject) {
        return ((JSONObject)jSONObject.get((Object)"transactionJSON")).get((Object)"chain") + ":" + jSONObject.get((Object)"fullHash");
    }

    private JSONObject buildMaxFeesJSON(int n, long l) {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put((Object)("" + n), (Object)Long.toUnsignedString(l));
        return jSONObject;
    }
}

