/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.assetexchange;

import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.account.HoldingType;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.client.IssueAssetBuilder;
import nxt.http.client.TransferAssetBuilder;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class AssetExchangeTest
extends BlockchainTest {
    public static IssueAssetBuilder.IssueAssetResult issueAsset(Tester tester, String string) {
        IssueAssetBuilder.IssueAssetResult issueAssetResult = new IssueAssetBuilder(tester, string).issueAsset();
        BlockchainTest.generateBlock();
        return issueAssetResult;
    }

    static TransferAssetBuilder.TransferResult transfer(String string, Tester tester, Tester tester2, long l) {
        return AssetExchangeTest.transfer(string, tester, tester2, l, ChildChain.IGNIS.ONE_COIN);
    }

    public static TransferAssetBuilder.TransferResult transfer(String string, Tester tester, Tester tester2, long l, long l2) {
        TransferAssetBuilder.TransferResult transferResult = new TransferAssetBuilder(string, tester, tester2).setQuantityQNT(l).setFee(l2).transfer();
        BlockchainTest.generateBlock();
        return transferResult;
    }

    static JSONObject payDividend(String string, Tester tester, int n, long l, Chain chain, byte by, String string2) {
        APICall aPICall = new APICall.Builder("dividendPayment").param("secretPhrase", tester.getSecretPhrase()).param("asset", string).param("height", n).param("holdingType", by).param("holding", string2).param("amountNQTPerShare", l).param("feeNQT", chain.ONE_COIN).chain(chain.getId()).build();
        JSONObject jSONObject = aPICall.invoke();
        BlockchainTest.generateBlock();
        return jSONObject;
    }

    @Test
    public void ignisDividend() {
        String string = AssetExchangeTest.issueAsset(ALICE, "divSender").getAssetIdString();
        AssetExchangeTest.transfer(string, ALICE, BOB, 3000000L);
        AssetExchangeTest.transfer(string, ALICE, CHUCK, 2000000L);
        AssetExchangeTest.transfer(string, ALICE, DAVE, 1000000L);
        AssetExchangeTest.generateBlock();
        int n = ChildChain.IGNIS.getId();
        AssetExchangeTest.payDividend(string, ALICE, Nxt.getBlockchain().getHeight(), 1000000L, (Chain)ChildChain.IGNIS, HoldingType.COIN.getCode(), "");
        AssetExchangeTest.generateBlock();
        Assert.assertEquals((long)(3L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(n));
        Assert.assertEquals((long)(2L * ChildChain.IGNIS.ONE_COIN), (long)CHUCK.getChainBalanceDiff(n));
        Assert.assertEquals((long)ChildChain.IGNIS.ONE_COIN, (long)DAVE.getChainBalanceDiff(n));
    }

    @Test
    public void AEURDividend() {
        String string = AssetExchangeTest.issueAsset(RIKER, "divSender").getAssetIdString();
        AssetExchangeTest.transfer(string, RIKER, BOB, 5555555L);
        AssetExchangeTest.transfer(string, RIKER, CHUCK, 2222222L);
        AssetExchangeTest.transfer(string, RIKER, DAVE, 1111111L);
        AssetExchangeTest.generateBlock();
        int n = ChildChain.AEUR.getId();
        AssetExchangeTest.payDividend(string, RIKER, Nxt.getBlockchain().getHeight(), 1L, (Chain)ChildChain.AEUR, HoldingType.COIN.getCode(), "");
        AssetExchangeTest.generateBlock();
        Assert.assertEquals((long)(-888L - ChildChain.AEUR.ONE_COIN), (long)RIKER.getChainBalanceDiff(n));
        Assert.assertEquals((long)555L, (long)BOB.getChainBalanceDiff(n));
        Assert.assertEquals((long)222L, (long)CHUCK.getChainBalanceDiff(n));
        Assert.assertEquals((long)111L, (long)DAVE.getChainBalanceDiff(n));
    }

    @Test
    public void assetDividend() {
        String string = AssetExchangeTest.issueAsset(RIKER, "divSender").getAssetIdString();
        AssetExchangeTest.transfer(string, RIKER, BOB, 5555555L);
        AssetExchangeTest.transfer(string, RIKER, CHUCK, 2222222L);
        AssetExchangeTest.transfer(string, RIKER, DAVE, 1111111L);
        IssueAssetBuilder.IssueAssetResult issueAssetResult = AssetExchangeTest.issueAsset(RIKER, "divRecv");
        AssetExchangeTest.generateBlock();
        AssetExchangeTest.payDividend(string, RIKER, Nxt.getBlockchain().getHeight(), 1L, (Chain)ChildChain.AEUR, HoldingType.ASSET.getCode(), issueAssetResult.getAssetIdString());
        AssetExchangeTest.generateBlock();
        Assert.assertEquals((long)9999112L, (long)RIKER.getAssetQuantityDiff(issueAssetResult.getAssetId()));
        Assert.assertEquals((long)555L, (long)BOB.getAssetQuantityDiff(issueAssetResult.getAssetId()));
        Assert.assertEquals((long)222L, (long)CHUCK.getAssetQuantityDiff(issueAssetResult.getAssetId()));
        Assert.assertEquals((long)111L, (long)DAVE.getAssetQuantityDiff(issueAssetResult.getAssetId()));
    }

    @Test
    public void currencyDividend() {
        String string = AssetExchangeTest.issueAsset(ALICE, "divSender").getAssetIdString();
        AssetExchangeTest.transfer(string, ALICE, BOB, 5555555L);
        AssetExchangeTest.transfer(string, ALICE, CHUCK, 2222222L);
        AssetExchangeTest.transfer(string, ALICE, DAVE, 1111111L);
        String string2 = new TestCurrencyIssuance().issueCurrencyImpl();
        AssetExchangeTest.generateBlock();
        AssetExchangeTest.payDividend(string, ALICE, Nxt.getBlockchain().getHeight(), 1L, (Chain)ChildChain.AEUR, HoldingType.CURRENCY.getCode(), string2);
        AssetExchangeTest.generateBlock();
        Assert.assertEquals((long)99112L, (long)ALICE.getCurrencyUnitsDiff(Long.parseUnsignedLong(string2)));
        Assert.assertEquals((long)555L, (long)BOB.getCurrencyUnitsDiff(Long.parseUnsignedLong(string2)));
        Assert.assertEquals((long)222L, (long)CHUCK.getCurrencyUnitsDiff(Long.parseUnsignedLong(string2)));
        Assert.assertEquals((long)111L, (long)DAVE.getCurrencyUnitsDiff(Long.parseUnsignedLong(string2)));
    }
}

