/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.assetexchange;

import java.util.List;
import nxt.BlockchainTest;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.assetexchange.AssetExchangeTest;
import nxt.http.client.GetAssetPropertiesBuilder;
import nxt.http.client.SetAssetPropertyBuilder;
import nxt.util.JSONAssert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.ComparisonFailure;
import org.junit.Test;

public class AssetPropertiesTest
extends BlockchainTest {
    @Test
    public void testSetGetProperty() {
        this.testSetGetProperty("some value");
    }

    @Test
    public void testDeleteProperty() {
        long l = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetId();
        new SetAssetPropertyBuilder(ALICE, l, "prop1", "value1").invokeNoError();
        AssetPropertiesTest.generateBlock();
        this.createDeletePropertyBuilder(ALICE, l, "prop1").build().invokeNoError();
        AssetPropertiesTest.generateBlock();
        JSONObject jSONObject = new GetAssetPropertiesBuilder(l).invokeNoError();
        List<JSONObject> list = new JSONAssert(jSONObject).array("properties", JSONObject.class);
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testDeletePropertyOtherAccount() {
        long l = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetId();
        new SetAssetPropertyBuilder(BOB, l, "prop", "value1").invokeNoError();
        AssetPropertiesTest.generateBlock();
        this.createDeletePropertyBuilder(ALICE, l, "prop").param("setter", BOB.getStrId()).build().invokeNoError();
        AssetPropertiesTest.generateBlock();
        JSONObject jSONObject = new GetAssetPropertiesBuilder(l).invokeNoError();
        List<JSONObject> list = new JSONAssert(jSONObject).array("properties", JSONObject.class);
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testDeletePropertyOtherAccountRejected() {
        long l = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetId();
        new SetAssetPropertyBuilder(ALICE, l, "some prop", "value1").invokeNoError();
        AssetPropertiesTest.generateBlock();
        JSONObject jSONObject = this.createDeletePropertyBuilder(BOB, l, "some prop").param("setter", ALICE.getStrId()).build().invoke();
        String string = new JSONAssert(jSONObject).str("errorDescription");
        Assert.assertEquals((Object)"Incorrect \"property\" (cannot be deleted by this account)", (Object)string);
        AssetPropertiesTest.generateBlock();
        JSONObject jSONObject2 = new GetAssetPropertiesBuilder(l).invokeNoError();
        this.assertOnlyProperty("some prop", "value1", jSONObject2);
        AssetPropertiesTest.assertPropertySetter(ALICE, (JSONObject)((JSONArray)jSONObject2.get((Object)"properties")).get(0));
    }

    private APICall.Builder createDeletePropertyBuilder(Tester tester, long l, String string) {
        return new APICall.Builder("deleteAssetProperty").param("secretPhrase", tester.getSecretPhrase()).param("asset", Long.toUnsignedString(l)).param("feeNQT", 3L * ChildChain.IGNIS.ONE_COIN).param("property", string);
    }

    @Test
    public void testSetGetPropertyNullValue() {
        this.testSetGetProperty(null);
    }

    @Test
    public void testSetGetPropertyMultipleAccounts() {
        long l = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetId();
        new SetAssetPropertyBuilder(ALICE, l, "prop1", "some value").invokeNoError();
        new SetAssetPropertyBuilder(BOB, l, "prop1", "some other value").invokeNoError();
        AssetPropertiesTest.generateBlock();
        JSONObject jSONObject = new GetAssetPropertiesBuilder(l).invokeNoError();
        this.assertContainsProperty(ALICE, "prop1", "some value", jSONObject);
        this.assertContainsProperty(BOB, "prop1", "some other value", jSONObject);
    }

    @Test
    public void testSetGetPropertyOfSingleAccount() {
        long l = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetId();
        new SetAssetPropertyBuilder(ALICE, l, "prop1", "some value").invokeNoError();
        new SetAssetPropertyBuilder(BOB, l, "prop1", "some other value").invokeNoError();
        AssetPropertiesTest.generateBlock();
        JSONObject jSONObject = new GetAssetPropertiesBuilder(l).setter(ALICE).invokeNoError();
        this.assertOnlyProperty("prop1", "some value", jSONObject);
        AssetPropertiesTest.assertPropertySetter(ALICE, jSONObject);
    }

    private void assertContainsProperty(Tester tester, String string, String string2, JSONObject jSONObject) {
        List<JSONObject> list = new JSONAssert(jSONObject).array("properties", JSONObject.class);
        for (JSONObject jSONObject2 : list) {
            try {
                AssetPropertiesTest.assertPropertyNameValue(string, string2, jSONObject2);
                AssetPropertiesTest.assertPropertySetter(tester, jSONObject2);
                return;
            }
            catch (ComparisonFailure comparisonFailure) {
            }
        }
        Assert.fail((String)String.format("Not found property (%s, %s, %s) in response: %s", tester.getAccount(), string, string2, jSONObject));
    }

    private void testSetGetProperty(String string) {
        long l = AssetExchangeTest.issueAsset(ALICE, "AssetC").getAssetId();
        new SetAssetPropertyBuilder(ALICE, l, "prop", string).invokeNoError();
        AssetPropertiesTest.generateBlock();
        JSONObject jSONObject = new GetAssetPropertiesBuilder(l).invokeNoError();
        this.assertOnlyProperty("prop", string, jSONObject);
        AssetPropertiesTest.assertPropertySetter(ALICE, (JSONObject)((JSONArray)jSONObject.get((Object)"properties")).get(0));
    }

    private void assertOnlyProperty(String string, String string2, JSONObject jSONObject) {
        List<JSONObject> list = new JSONAssert(jSONObject).array("properties", JSONObject.class);
        JSONObject jSONObject2 = list.get(0);
        AssetPropertiesTest.assertPropertyNameValue(string, string2, jSONObject2);
        Assert.assertEquals((long)1L, (long)list.size());
    }

    private static void assertPropertyNameValue(String string, String string2, JSONObject jSONObject) {
        Assert.assertEquals((Object)string, (Object)jSONObject.get((Object)"property"));
        Assert.assertEquals((Object)string2, (Object)jSONObject.get((Object)"value"));
    }

    private static void assertPropertySetter(Tester tester, JSONObject jSONObject) {
        Assert.assertEquals((Object)Long.toUnsignedString(tester.getId()), (Object)jSONObject.get((Object)"setter"));
    }
}

