/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.bundling;

import java.util.Collections;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.assetexchange.AssetExchangeTest;
import nxt.http.bundling.BundlerTest;
import nxt.http.client.PlaceAssetOrderBuilder;
import nxt.util.JSONAssert;
import org.junit.Assert;
import org.junit.Test;

public class AssetBundlerTest
extends BundlerTest {
    @Test
    public void testAssetTransferBundler() {
        String string = this.issueAsset();
        String string2 = this.issueAsset();
        this.startAssetBundler(string);
        String string3 = AssetExchangeTest.transfer(string, ALICE, CHUCK, 10L, 0L).getFullHash();
        Assert.assertTrue((boolean)this.isBundled(string3));
        string3 = AssetExchangeTest.transfer(string2, ALICE, CHUCK, 10L, 0L).getFullHash();
        Assert.assertFalse((boolean)this.isBundled(string3));
    }

    @Test
    public void testAssetBidBundler() {
        String string = this.issueAsset();
        this.startAssetBundler(string);
        String string2 = this.placeAssetOrder(ALICE, string, 10L, ChildChain.IGNIS.ONE_COIN, false);
        Assert.assertTrue((boolean)this.isBundled(string2));
        string2 = this.placeAssetOrder(CHUCK, string, 10L, ChildChain.IGNIS.ONE_COIN, true);
        Assert.assertTrue((boolean)this.isBundled(string2));
        string2 = this.placeAssetOrder(ALICE, string, 10L, ChildChain.IGNIS.ONE_COIN * 2L, false);
        Assert.assertTrue((boolean)this.isBundled(string2));
        String string3 = Tester.hexFullHashToStringId(string2);
        string2 = this.placeAssetOrder(CHUCK, string, 10L, ChildChain.IGNIS.ONE_COIN, true);
        Assert.assertTrue((boolean)this.isBundled(string2));
        String string4 = Tester.hexFullHashToStringId(string2);
        string2 = this.cancelAssetOrder(ALICE, string3, false);
        Assert.assertTrue((boolean)this.isBundled(string2));
        string2 = this.cancelAssetOrder(CHUCK, string4, true);
        Assert.assertTrue((boolean)this.isBundled(string2));
    }

    @Test
    public void testAssetBundlerWithQuota() {
        String string = this.issueAsset();
        int n = 4;
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("startBundler").secretPhrase(ALICE.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("filter", new String[]{"AssetBundler:" + string, "QuotaBundler:" + n}).param("minRateNQTPerFXT", 0).param("feeCalculatorName", "MIN_FEE").build().invoke());
        jSONAssert.str("totalFeesLimitFQT");
        String string2 = AssetExchangeTest.transfer(string, ALICE, BOB, 100L, 0L).getFullHash();
        Assert.assertTrue((boolean)this.isBundled(string2));
        for (int i = 0; i < n; ++i) {
            string2 = AssetExchangeTest.transfer(string, BOB, CHUCK, 10L, 0L).getFullHash();
            Assert.assertTrue((boolean)this.isBundled(string2));
        }
        string2 = AssetExchangeTest.transfer(string, BOB, CHUCK, 10L, 0L).getFullHash();
        Assert.assertFalse((boolean)this.isBundled(string2));
        string2 = AssetExchangeTest.transfer(string, CHUCK, BOB, 10L, 0L).getFullHash();
        Assert.assertTrue((boolean)this.isBundled(string2));
        string2 = AssetExchangeTest.transfer(string, CHUCK, new Tester("Unknown account secret " + System.currentTimeMillis()), 10L, 0L).getFullHash();
        Assert.assertFalse((boolean)this.isBundled(string2));
    }

    private String placeAssetOrder(Tester tester, String string, long l, long l2, boolean bl) {
        PlaceAssetOrderBuilder placeAssetOrderBuilder = new PlaceAssetOrderBuilder(tester, string, l, l2);
        PlaceAssetOrderBuilder.PlaceOrderResult placeOrderResult = bl ? placeAssetOrderBuilder.placeBidOrder() : placeAssetOrderBuilder.placeAskOrder();
        AssetBundlerTest.generateBlock();
        return placeOrderResult.getFullHash();
    }

    private String cancelAssetOrder(Tester tester, String string, boolean bl) {
        String string2 = new JSONAssert(new APICall.Builder(bl ? "cancelBidOrder" : "cancelAskOrder").param("secretPhrase", tester.getSecretPhrase()).param("order", string).param("feeNQT", 0).build().invoke()).str("fullHash");
        AssetBundlerTest.generateBlock();
        return string2;
    }

    private void startAssetBundler(String string) {
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("startBundler").secretPhrase(BOB.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("filter", "AssetBundler:" + string).param("minRateNQTPerFXT", 0).param("feeCalculatorName", "MIN_FEE").build().invoke());
        jSONAssert.str("totalFeesLimitFQT");
    }

    private String issueAsset() {
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("issueAsset").param("secretPhrase", ALICE.getSecretPhrase()).param("name", "Bundl").param("description", "asset bundle testing").param("quantityQNT", 10000000).param("decimals", 4).param("feeNQT", 1000L * ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build().invoke());
        String string = jSONAssert.str("fullHash");
        String string2 = Tester.hexFullHashToStringId(string);
        AssetBundlerTest.bundleTransactions(Collections.singletonList(string));
        AssetBundlerTest.generateBlock();
        return string2;
    }
}

