/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.bundling;

import java.math.BigInteger;
import java.util.Collections;
import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.account.PaymentTransactionType;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.http.APICall;
import nxt.util.JSON;
import nxt.util.JSONAssert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;

public class BundlerTest
extends BlockchainTest {
    @BeforeClass
    public static void init() {
        BundlerTest.initNxt(Collections.emptyMap());
        BundlerTest.initBlockchainTest();
        for (Chain chain : ChildChain.getAll()) {
            JSONObject jSONObject = new APICall.Builder("stopBundler").secretPhrase(FORGY.getSecretPhrase()).param("chain", chain.getId()).build().invoke();
            Assert.assertEquals((Object)Boolean.TRUE, (Object)jSONObject.get((Object)"stoppedBundler"));
        }
    }

    @Override
    @After
    public void destroy() {
        super.destroy();
        new APICall.Builder("stopBundler").param("chain", ChildChain.IGNIS.getId()).build().invoke();
    }

    protected long startTwoRulesBundler(long l, long l2) {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put((Object)"name", (Object)"PersonalBundler");
        JSONArray jSONArray2 = new JSONArray();
        jSONArray2.add((Object)jSONObject2);
        jSONObject.put((Object)"filters", (Object)jSONArray2);
        jSONObject.put((Object)"feeCalculatorName", (Object)"MIN_FEE");
        jSONObject.put((Object)"minRateNQTPerFXT", (Object)"0");
        jSONObject.put((Object)"overpayFQTPerFXT", (Object)l2);
        jSONArray.add((Object)jSONObject);
        jSONObject = new JSONObject();
        jSONObject.put((Object)"feeCalculatorName", (Object)"MIN_FEE");
        jSONObject.put((Object)"minRateNQTPerFXT", (Object)Long.toUnsignedString(l));
        jSONArray.add((Object)jSONObject);
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("startBundler").secretPhrase(BOB.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("bundlingRulesJSON", JSON.toString((JSONStreamAware)jSONArray)).build().invoke());
        jSONAssert.str("totalFeesLimitFQT");
        return l;
    }

    protected long getMinFeeNQT(long l) {
        return BigInteger.valueOf(this.getMinFeeFQT()).multiply(BigInteger.valueOf(l)).divide(BigInteger.valueOf(FxtChain.FXT.ONE_COIN)).longValueExact();
    }

    protected long getMinFeeFQT() {
        return PaymentTransactionType.ORDINARY.getBaselineFee(null).getFee(null, null);
    }

    protected boolean bundleTransaction(Tester tester, long l) {
        String string = this.createTransaction(tester, l, null);
        BundlerTest.generateBlock();
        return this.isBundled(string);
    }

    protected boolean isBundled(String string) {
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("getTransaction").param("fullHash", string).build().invoke());
        Object object = jSONAssert.getJson().get((Object)"errorDescription");
        if ("Unknown transaction".equals(object)) {
            return false;
        }
        return (long)Nxt.getBlockchain().getHeight() == jSONAssert.integer("height");
    }

    protected String createTransaction(Tester tester, long l, String string) {
        APICall.Builder builder = new APICall.Builder("sendMoney").secretPhrase(tester.getSecretPhrase()).recipient(DAVE.getId()).param("amountNQT", 10L * ChildChain.IGNIS.ONE_COIN).param("feeNQT", l);
        if (string != null) {
            builder.param("message", string);
        }
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        return jSONAssert.str("fullHash");
    }
}

