/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.bundling;

import java.util.Collections;
import nxt.Nxt;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.bundling.BundlerTest;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.ms.CurrencyType;
import nxt.util.JSONAssert;
import org.junit.Assert;
import org.junit.Test;

public class CurrencyBundlerTest
extends BundlerTest {
    @Test
    public void testTransfer() {
        JSONAssert jSONAssert = new JSONAssert(new TestCurrencyIssuance.Builder().type(CurrencyType.EXCHANGEABLE.getCode()).initialSupply(100000L).build().invoke());
        String string = jSONAssert.str("fullHash");
        String string2 = this.bundleIssueCurrency(string);
        this.startCurrencyBundler(string2);
        jSONAssert = new JSONAssert(new APICall.Builder("transferCurrency").param("secretPhrase", ALICE.getSecretPhrase()).param("currency", string2).param("recipient", BOB.getStrId()).param("unitsQNT", "2000").feeNQT(0L).build().invoke());
        string = jSONAssert.str("fullHash");
        CurrencyBundlerTest.generateBlock();
        Assert.assertTrue((boolean)this.isBundled(string));
    }

    @Test
    public void testExchange() {
        JSONAssert jSONAssert = new JSONAssert(new TestCurrencyIssuance.Builder().type(CurrencyType.EXCHANGEABLE.getCode()).initialSupply(100000L).build().invoke());
        String string = jSONAssert.str("fullHash");
        String string2 = this.bundleIssueCurrency(string);
        this.startCurrencyBundler(string2);
        jSONAssert = new JSONAssert(new APICall.Builder("publishExchangeOffer").secretPhrase(ALICE.getSecretPhrase()).feeNQT(0L).param("deadline", "1440").param("currency", string2).param("buyRateNQTPerUnit", "95").param("sellRateNQTPerUnit", "105").param("totalBuyLimitQNT", "10000").param("totalSellLimitQNT", "5000").param("initialBuySupplyQNT", "1000").param("initialSellSupplyQNT", "500").param("expirationHeight", "2147483647").build().invoke());
        string = jSONAssert.str("fullHash");
        CurrencyBundlerTest.generateBlock();
        Assert.assertTrue((boolean)this.isBundled(string));
        jSONAssert = new JSONAssert(new APICall.Builder("currencyBuy").secretPhrase(BOB.getSecretPhrase()).feeNQT(0L).param("currency", string2).param("rateNQTPerUnit", "106").param("unitsQNT", "200").build().invoke());
        string = jSONAssert.str("fullHash");
        CurrencyBundlerTest.generateBlock();
        Assert.assertTrue((boolean)this.isBundled(string));
        jSONAssert = new JSONAssert(new APICall.Builder("currencySell").secretPhrase(BOB.getSecretPhrase()).feeNQT(0L).param("currency", string2).param("rateNQTPerUnit", "94").param("unitsQNT", "200").build().invoke());
        string = jSONAssert.str("fullHash");
        CurrencyBundlerTest.generateBlock();
        Assert.assertTrue((boolean)this.isBundled(string));
    }

    @Test
    public void testReservable() {
        JSONAssert jSONAssert = new JSONAssert(new TestCurrencyIssuance.Builder().type(CurrencyType.RESERVABLE.getCode() | CurrencyType.CLAIMABLE.getCode()).issuanceHeight(Nxt.getBlockchain().getHeight() + 5).minReservePerUnitNQT(1L).initialSupply(0L).reserveSupply(100000L).build().invoke());
        String string = jSONAssert.str("fullHash");
        String string2 = this.bundleIssueCurrency(string);
        this.startCurrencyBundler(string2);
        jSONAssert = new JSONAssert(new APICall.Builder("currencyReserveIncrease").secretPhrase(CHUCK.getSecretPhrase()).feeNQT(0L).param("currency", string2).param("amountPerUnitNQT", "2").build().invoke());
        string = jSONAssert.str("fullHash");
        CurrencyBundlerTest.generateBlock();
        Assert.assertTrue((boolean)this.isBundled(string));
        CurrencyBundlerTest.generateBlocks(5);
        jSONAssert = new JSONAssert(new APICall.Builder("currencyReserveClaim").secretPhrase(CHUCK.getSecretPhrase()).feeNQT(0L).param("currency", string2).param("unitsQNT", "2000").build().invoke());
        string = jSONAssert.str("fullHash");
        CurrencyBundlerTest.generateBlock();
        Assert.assertTrue((boolean)this.isBundled(string));
    }

    private String bundleIssueCurrency(String string) {
        String string2 = Tester.hexFullHashToStringId(string);
        CurrencyBundlerTest.bundleTransactions(Collections.singletonList(string));
        CurrencyBundlerTest.generateBlock();
        return string2;
    }

    private void startCurrencyBundler(String string) {
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("startBundler").secretPhrase(BOB.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("filter", "CurrencyBundler:" + string).param("minRateNQTPerFXT", 0).param("feeCalculatorName", "MIN_FEE").build().invoke());
        jSONAssert.str("totalFeesLimitFQT");
    }
}

