/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.bundling;

import java.util.Collections;
import nxt.Nxt;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.bundling.BundlerTest;
import nxt.util.JSONAssert;
import org.junit.Assert;
import org.junit.Test;

public class PurchaseBundlerTest
extends BundlerTest {
    @Test
    public void testPurchaseAndFeedback() {
        this.startPurchaseBundler(ALICE);
        long l = ChildChain.IGNIS.ONE_COIN;
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("dgsListing").secretPhrase(ALICE.getSecretPhrase()).feeNQT(0L).param("name", "TestDGS").param("quantity", "10").param("priceNQT", l).build().invoke());
        String string = jSONAssert.id();
        PurchaseBundlerTest.bundleTransactions(Collections.singletonList(jSONAssert.fullHash()));
        PurchaseBundlerTest.generateBlock();
        jSONAssert = new JSONAssert(new APICall.Builder("dgsPurchase").secretPhrase(CHUCK.getSecretPhrase()).feeNQT(0L).param("goods", string).param("priceNQT", l).param("quantity", 1).param("deliveryDeadlineTimestamp", Nxt.getEpochTime() + 100).build().invoke());
        String string2 = jSONAssert.id();
        PurchaseBundlerTest.generateBlock();
        Assert.assertTrue((boolean)this.isBundled(jSONAssert.fullHash()));
        jSONAssert = new JSONAssert(new APICall.Builder("dgsDelivery").secretPhrase(ALICE.getSecretPhrase()).feeNQT(0L).param("purchase", string2).param("goodsToEncrypt", "a").build().invoke());
        PurchaseBundlerTest.bundleTransactions(Collections.singletonList(jSONAssert.fullHash()));
        PurchaseBundlerTest.generateBlock();
        jSONAssert = new JSONAssert(new APICall.Builder("dgsFeedback").secretPhrase(CHUCK.getSecretPhrase()).feeNQT(0L).param("purchase", string2).param("message", "my feedback 123").build().invoke());
        PurchaseBundlerTest.generateBlock();
        Assert.assertTrue((boolean)this.isBundled(jSONAssert.fullHash()));
    }

    private void startPurchaseBundler(Tester tester) {
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("startBundler").secretPhrase(BOB.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("filter", "PurchaseBundler:" + tester.getStrId()).param("minRateNQTPerFXT", 0).param("feeCalculatorName", "MIN_FEE").build().invoke());
        jSONAssert.str("totalFeesLimitFQT");
    }
}

