/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.bundling;

import nxt.BlockchainTest;
import nxt.Tester;
import nxt.addons.JO;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.shuffling.ShufflingUtil;
import nxt.shuffling.ShufflingStage;
import nxt.util.JSONAssert;
import org.junit.Assert;
import org.junit.Test;

public class TransactionTypeBundlerTest
extends BlockchainTest {
    @Test
    public void testSuccessfulShuffling() {
        this.startShufflingBundler("7:1,7:2,7:3,7:4,7:5");
        String string = new JSONAssert(ShufflingUtil.create(ALICE, 4)).fullHash();
        TransactionTypeBundlerTest.generateBlock();
        this.registration(string);
        this.processing(string);
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.VERIFICATION.getCode(), (Object)jO.get("stage"));
        String string2 = (String)jO.get("shufflingStateHash");
        this.verification(string, string2);
        jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ShufflingStage.DONE.getCode(), (Object)jO.get("stage"));
    }

    @Test
    public void testProcessingNotBundled() {
        this.startShufflingBundler("7:1,7:3,7:4,7:5");
        String string = new JSONAssert(ShufflingUtil.create(ALICE, 4)).fullHash();
        TransactionTypeBundlerTest.generateBlock();
        this.registration(string);
        TransactionTypeBundlerTest.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TransactionTypeBundlerTest.generateBlock();
        JO jO = ShufflingUtil.getShuffling(string);
        Assert.assertEquals((Object)ALICE.getStrId(), (Object)jO.get("assignee"));
    }

    private void registration(String string) {
        TransactionTypeBundlerTest.register(BOB, string);
        TransactionTypeBundlerTest.generateBlock();
        TransactionTypeBundlerTest.register(CHUCK, string);
        TransactionTypeBundlerTest.generateBlock();
        TransactionTypeBundlerTest.register(DAVE, string);
        TransactionTypeBundlerTest.generateBlock();
    }

    private void processing(String string) {
        TransactionTypeBundlerTest.process(string, ALICE, ShufflingUtil.ALICE_RECIPIENT);
        TransactionTypeBundlerTest.generateBlock();
        TransactionTypeBundlerTest.process(string, BOB, ShufflingUtil.BOB_RECIPIENT);
        TransactionTypeBundlerTest.generateBlock();
        TransactionTypeBundlerTest.process(string, CHUCK, ShufflingUtil.CHUCK_RECIPIENT);
        TransactionTypeBundlerTest.generateBlock();
        TransactionTypeBundlerTest.process(string, DAVE, ShufflingUtil.DAVE_RECIPIENT);
        TransactionTypeBundlerTest.generateBlock();
    }

    private void verification(String string, String string2) {
        TransactionTypeBundlerTest.verify(string, ALICE, string2);
        TransactionTypeBundlerTest.verify(string, BOB, string2);
        TransactionTypeBundlerTest.verify(string, CHUCK, string2);
        TransactionTypeBundlerTest.generateBlock();
    }

    private static void register(Tester tester, String string) {
        new JSONAssert(new APICall.Builder("shufflingRegister").secretPhrase(tester.getSecretPhrase()).param("shufflingFullHash", string).feeNQT(0L).build().invoke()).fullHash();
    }

    private static void process(String string, Tester tester, Tester tester2) {
        new JSONAssert(new APICall.Builder("shufflingProcess").param("shufflingFullHash", string).param("secretPhrase", tester.getSecretPhrase()).param("recipientSecretPhrase", tester2.getSecretPhrase()).feeNQT(0L).build().invoke()).fullHash();
    }

    private static void verify(String string, Tester tester, String string2) {
        new JSONAssert(new APICall.Builder("shufflingVerify").param("shufflingFullHash", string).param("secretPhrase", tester.getSecretPhrase()).param("shufflingStateHash", string2).feeNQT(0L).build().invoke());
    }

    private void startShufflingBundler(String string) {
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("startBundler").secretPhrase(BOB.getSecretPhrase()).param("chain", ChildChain.IGNIS.getId()).param("filter", "TransactionTypeBundler:" + string).param("minRateNQTPerFXT", 0).param("feeCalculatorName", "MIN_FEE").build().invoke());
        jSONAssert.str("totalFeesLimitFQT");
    }
}

