/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.client;

import java.util.List;
import nxt.http.APICall;
import nxt.util.JSONAssert;
import org.json.simple.JSONObject;

public class GetAccountCurrentOrderIdsBuilder {
    private final long accountId;
    private long assetId = 0L;
    private int firstIndex = 0;
    private int lastIndex = Integer.MAX_VALUE;

    public GetAccountCurrentOrderIdsBuilder(long l) {
        this.accountId = l;
    }

    public GetAccountCurrentOrderIdsBuilder setAssetId(String string) {
        return this.setAssetId(Long.parseUnsignedLong(string));
    }

    public GetAccountCurrentOrderIdsBuilder setAssetId(long l) {
        this.assetId = l;
        return this;
    }

    public GetAccountCurrentOrderIdsBuilder setFirstIndex(int n) {
        this.firstIndex = n;
        return this;
    }

    public GetAccountCurrentOrderIdsBuilder setLastIndex(int n) {
        this.lastIndex = n;
        return this;
    }

    public List<String> getAskOrders() {
        return this.getOrders("getAccountCurrentAskOrderIds", "askOrderIds");
    }

    public List<String> getBidOrders() {
        return this.getOrders("getAccountCurrentBidOrderIds", "bidOrderIds");
    }

    private List<String> getOrders(String string, String string2) {
        JSONObject jSONObject = new APICall.Builder(string).param("account", Long.toUnsignedString(this.accountId)).param("asset", Long.toUnsignedString(this.assetId)).param("firstIndex", this.firstIndex).param("lastIndex", this.lastIndex).build().invokeNoError();
        return new JSONAssert(jSONObject).array(string2, String.class);
    }
}

