/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.client;

import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import org.json.simple.JSONObject;

public class IssueAssetBuilder {
    public static final int ASSET_QNT = 10000000;
    public static final int ASSET_DECIMALS = 4;
    private final String secretPhrase;
    private final String name;
    private String description = "asset testing";
    private int quantityQNT = 10000000;
    private int decimals = 4;
    private long feeNQT;
    private int deadline;

    public IssueAssetBuilder(Tester tester, String string) {
        this.feeNQT = 1000L * ChildChain.IGNIS.ONE_COIN;
        this.deadline = 1440;
        this.secretPhrase = tester.getSecretPhrase();
        this.name = string;
    }

    public IssueAssetResult issueAsset() {
        return new IssueAssetResult(this.invokeNoErr());
    }

    private JSONObject invokeNoErr() {
        return this.build().invokeNoError();
    }

    private APICall build() {
        return new APICall.Builder("issueAsset").param("secretPhrase", this.secretPhrase).param("name", this.name).param("description", this.description).param("quantityQNT", this.quantityQNT).param("decimals", this.decimals).param("feeNQT", this.feeNQT).param("deadline", this.deadline).build();
    }

    public IssueAssetBuilder setDescription(String string) {
        this.description = string;
        return this;
    }

    public IssueAssetBuilder setQuantityQNT(int n) {
        this.quantityQNT = n;
        return this;
    }

    public IssueAssetBuilder setDecimals(int n) {
        this.decimals = n;
        return this;
    }

    public IssueAssetBuilder setFeeNQT(long l) {
        this.feeNQT = l;
        return this;
    }

    public IssueAssetBuilder setDeadline(int n) {
        this.deadline = n;
        return this;
    }

    public static class IssueAssetResult {
        private final JSONObject jsonObject;

        IssueAssetResult(JSONObject jSONObject) {
            this.jsonObject = jSONObject;
        }

        public long getAssetId() {
            return Long.parseUnsignedLong(this.getAssetIdString());
        }

        public String getAssetIdString() {
            return Tester.responseToStringId(this.jsonObject);
        }
    }
}

