/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.client;

import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.util.JSONAssert;
import org.json.simple.JSONObject;

public class TransferAssetBuilder {
    private final long assetId;
    private final Tester from;
    private final Tester to;
    private long quantityQNT = 1L;
    private long fee;

    public TransferAssetBuilder(String string, Tester tester, Tester tester2) {
        this(Long.parseUnsignedLong(string), tester, tester2);
    }

    public TransferAssetBuilder(long l, Tester tester, Tester tester2) {
        this.fee = ChildChain.IGNIS.ONE_COIN;
        this.assetId = l;
        this.from = tester;
        this.to = tester2;
    }

    public TransferAssetBuilder setQuantityQNT(long l) {
        this.quantityQNT = l;
        return this;
    }

    public TransferAssetBuilder setFee(long l) {
        this.fee = l;
        return this;
    }

    private APICall build() {
        return new APICall.Builder("transferAsset").param("secretPhrase", this.from.getSecretPhrase()).param("recipient", this.to.getRsAccount()).param("asset", Long.toUnsignedString(this.assetId)).param("quantityQNT", this.quantityQNT).param("feeNQT", this.fee).build();
    }

    public TransferResult transfer() {
        return new TransferResult(this.build().invokeNoError());
    }

    public APICall.InvocationError transferWithError() {
        return this.build().invokeWithError();
    }

    public static class TransferResult {
        private final JSONObject jsonObject;

        TransferResult(JSONObject jSONObject) {
            this.jsonObject = jSONObject;
        }

        public String getFullHash() {
            return new JSONAssert(this.jsonObject).str("fullHash");
        }
    }
}

