/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.coinexchange;

import nxt.BlockchainTest;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class CoinExchangeTest
extends BlockchainTest {
    @Test
    public void simpleExchange() {
        long l = 25L;
        long l2 = l * ChildChain.AEUR.ONE_COIN;
        long l3 = 4L;
        long l4 = l3 * ChildChain.IGNIS.ONE_COIN;
        APICall aPICall = new APICall.Builder("exchangeCoins").secretPhrase(ALICE.getSecretPhrase()).param("feeRateNQTPerFXT", ChildChain.IGNIS.ONE_COIN).param("chain", ChildChain.IGNIS.getId()).param("exchange", ChildChain.AEUR.getId()).param("quantityQNT", l2).param("priceNQTPerCoin", l4).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("exchangeCoins: " + jSONObject));
        CoinExchangeTest.generateBlock();
        JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        String string = Tester.responseToStringId(jSONObject2);
        aPICall = new APICall.Builder("getCoinExchangeOrder").param("order", string).build();
        jSONObject = aPICall.invoke();
        Assert.assertEquals((Object)Long.toString(25L * ChildChain.AEUR.ONE_COIN), (Object)jSONObject.get((Object)"quantityQNT"));
        Assert.assertEquals((Object)Long.toString(4L * ChildChain.IGNIS.ONE_COIN), (Object)jSONObject.get((Object)"bidNQTPerCoin"));
        Assert.assertEquals((Object)Long.toString((long)(0.25 * (double)ChildChain.AEUR.ONE_COIN)), (Object)jSONObject.get((Object)"askNQTPerCoin"));
        aPICall = new APICall.Builder("exchangeCoins").secretPhrase(BOB.getSecretPhrase()).param("feeRateNQTPerFXT", ChildChain.AEUR.ONE_COIN).param("chain", ChildChain.AEUR.getId()).param("exchange", ChildChain.IGNIS.getId()).param("quantityQNT", 100L * ChildChain.IGNIS.ONE_COIN + 10L * ChildChain.IGNIS.ONE_COIN).param("priceNQTPerCoin", ChildChain.AEUR.ONE_COIN / 4L).build();
        jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("exchangeCoins: " + jSONObject));
        CoinExchangeTest.generateBlock();
        jSONObject2 = (JSONObject)jSONObject.get((Object)"transactionJSON");
        string = Tester.responseToStringId(jSONObject2);
        aPICall = new APICall.Builder("getCoinExchangeOrder").param("order", string).build();
        jSONObject = aPICall.invoke();
        Assert.assertEquals((Object)Long.toString(10L * ChildChain.IGNIS.ONE_COIN), (Object)jSONObject.get((Object)"quantityQNT"));
        Assert.assertEquals((Object)Long.toString((long)(0.25 * (double)ChildChain.AEUR.ONE_COIN)), (Object)jSONObject.get((Object)"bidNQTPerCoin"));
        Assert.assertEquals((Object)Long.toString(4L * ChildChain.IGNIS.ONE_COIN), (Object)jSONObject.get((Object)"askNQTPerCoin"));
        aPICall = new APICall.Builder("getCoinExchangeTrades").param("chain", ChildChain.AEUR.getId()).param("account", BOB.getRsAccount()).build();
        jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("GetCoinExchangeTrades: " + jSONObject));
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"trades");
        JSONObject jSONObject3 = (JSONObject)jSONArray.get(0);
        Assert.assertEquals((long)ChildChain.AEUR.getId(), (long)((int)((Long)jSONObject3.get((Object)"chain")).longValue()));
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)((int)((Long)jSONObject3.get((Object)"exchange")).longValue()));
        Assert.assertEquals((Object)("" + 100L * ChildChain.IGNIS.ONE_COIN), (Object)jSONObject3.get((Object)"quantityQNT"));
        Assert.assertEquals((Object)("" + (long)(0.25 * (double)ChildChain.AEUR.ONE_COIN)), (Object)jSONObject3.get((Object)"priceNQTPerCoin"));
        aPICall = new APICall.Builder("getCoinExchangeTrades").param("chain", ChildChain.IGNIS.getId()).param("account", ALICE.getRsAccount()).build();
        jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("GetCoinExchangeTrades: " + jSONObject));
        jSONArray = (JSONArray)jSONObject.get((Object)"trades");
        jSONObject3 = (JSONObject)jSONArray.get(0);
        Assert.assertEquals((long)ChildChain.IGNIS.getId(), (long)((int)((Long)jSONObject3.get((Object)"chain")).longValue()));
        Assert.assertEquals((long)ChildChain.AEUR.getId(), (long)((int)((Long)jSONObject3.get((Object)"exchange")).longValue()));
        Assert.assertEquals((Object)("" + 25L * ChildChain.AEUR.ONE_COIN), (Object)jSONObject3.get((Object)"quantityQNT"));
        Assert.assertEquals((Object)("" + 4L * ChildChain.IGNIS.ONE_COIN), (Object)jSONObject3.get((Object)"priceNQTPerCoin"));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - ChildChain.IGNIS.ONE_COIN / 100L), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(25L * ChildChain.AEUR.ONE_COIN), (long)ALICE.getChainBalanceDiff(ChildChain.AEUR.getId()));
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-25L * ChildChain.AEUR.ONE_COIN - ChildChain.AEUR.ONE_COIN / 100L), (long)BOB.getChainBalanceDiff(ChildChain.AEUR.getId()));
    }

    @Test
    public void ronsSample() {
        long l = 5L * ChildChain.AEUR.ONE_COIN;
        long l2 = (long)(0.75 * (double)ChildChain.IGNIS.ONE_COIN);
        APICall aPICall = new APICall.Builder("exchangeCoins").secretPhrase(ALICE.getSecretPhrase()).param("feeRateNQTPerFXT", ChildChain.IGNIS.ONE_COIN).param("chain", ChildChain.IGNIS.getId()).param("exchange", ChildChain.AEUR.getId()).param("quantityQNT", l).param("priceNQTPerCoin", l2).build();
        JSONObject jSONObject = aPICall.invoke();
        String string = Tester.responseToStringId(jSONObject);
        CoinExchangeTest.generateBlock();
        long l3 = 5L * ChildChain.IGNIS.ONE_COIN;
        long l4 = (long)(1.35 * (double)ChildChain.AEUR.ONE_COIN);
        aPICall = new APICall.Builder("exchangeCoins").secretPhrase(BOB.getSecretPhrase()).param("feeRateNQTPerFXT", ChildChain.AEUR.ONE_COIN).param("chain", ChildChain.AEUR.getId()).param("exchange", ChildChain.IGNIS.getId()).param("quantityQNT", l3).param("priceNQTPerCoin", l4).build();
        jSONObject = aPICall.invoke();
        String string2 = Tester.responseToStringId(jSONObject);
        CoinExchangeTest.generateBlock();
        Assert.assertEquals((long)((long)(-3.75 * (double)ChildChain.IGNIS.ONE_COIN) - ChildChain.IGNIS.ONE_COIN / 100L), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(5L * ChildChain.AEUR.ONE_COIN), (long)ALICE.getChainBalanceDiff(ChildChain.AEUR.getId()));
        Assert.assertEquals((long)((long)(3.75 * (double)ChildChain.IGNIS.ONE_COIN)), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-5L * ChildChain.AEUR.ONE_COIN - ChildChain.AEUR.ONE_COIN / 100L), (long)BOB.getChainBalanceDiff(ChildChain.AEUR.getId()));
        aPICall = new APICall.Builder("getCoinExchangeOrder").param("order", string).build();
        jSONObject = aPICall.invoke();
        Assert.assertEquals((Object)5L, (Object)jSONObject.get((Object)"errorCode"));
        aPICall = new APICall.Builder("getCoinExchangeOrder").param("order", string2).build();
        jSONObject = aPICall.invoke();
        Assert.assertEquals((long)((long)(1.25 * (double)ChildChain.IGNIS.ONE_COIN)), (long)Long.parseLong((String)jSONObject.get((Object)"quantityQNT")));
        Assert.assertEquals((long)((long)(1.35 * (double)ChildChain.AEUR.ONE_COIN)), (long)Long.parseLong((String)jSONObject.get((Object)"bidNQTPerCoin")));
        Assert.assertEquals((long)((long)(0.74074074 * (double)ChildChain.IGNIS.ONE_COIN)), (long)Long.parseLong((String)jSONObject.get((Object)"askNQTPerCoin")));
    }
}

