/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.monetarysystem;

import nxt.BlockchainTest;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class DeleteCurrencyTest
extends BlockchainTest {
    @Test
    public void deleteByIssuer() {
        APICall aPICall = new TestCurrencyIssuance.Builder().naming("yjwcv", "YJWCV", "test1").build();
        TestCurrencyIssuance.issueCurrencyApi(aPICall);
        DeleteCurrencyTest.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("code", "YJWCV").build();
        JSONObject jSONObject = aPICall.invoke();
        String string = (String)jSONObject.get((Object)"currency");
        String string2 = (String)jSONObject.get((Object)"code");
        aPICall = new APICall.Builder("deleteCurrency").secretPhrase(ALICE.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).build();
        jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("deleteCurrencyResponse:" + jSONObject));
        DeleteCurrencyTest.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("code", string2).build();
        jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("getCurrencyResponse:" + jSONObject));
        Assert.assertEquals((Object)5L, (Object)jSONObject.get((Object)"errorCode"));
        Assert.assertEquals((Object)"Unknown currency", (Object)jSONObject.get((Object)"errorDescription"));
        aPICall = new TestCurrencyIssuance.Builder().naming("yjwcv", "YJWCV", "test1").build();
        TestCurrencyIssuance.issueCurrencyApi(aPICall);
        DeleteCurrencyTest.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("code", "YJWCV").build();
        jSONObject = aPICall.invoke();
        String string3 = (String)jSONObject.get((Object)"currency");
        String string4 = (String)jSONObject.get((Object)"code");
        Assert.assertNotEquals((Object)string, (Object)string3);
        Assert.assertEquals((Object)string2, (Object)string4);
    }

    @Test
    public void deleteByNonOwnerNotAllowed() {
        APICall aPICall = new TestCurrencyIssuance.Builder().naming("yjwcv", "YJWCV", "test1").build();
        TestCurrencyIssuance.issueCurrencyApi(aPICall);
        DeleteCurrencyTest.generateBlock();
        aPICall = new APICall.Builder("getAllCurrencies").build();
        JSONObject jSONObject = aPICall.invoke();
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"currencies");
        String string = (String)((JSONObject)jSONArray.get(0)).get((Object)"currency");
        String string2 = (String)((JSONObject)jSONArray.get(0)).get((Object)"code");
        aPICall = new APICall.Builder("deleteCurrency").secretPhrase(BOB.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).build();
        jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("deleteCurrencyResponse:" + jSONObject));
        Assert.assertEquals((Object)8L, (Object)jSONObject.get((Object)"errorCode"));
        aPICall = new APICall.Builder("getCurrency").param("code", string2).build();
        jSONObject = aPICall.invoke();
        Assert.assertEquals((Object)string, (Object)jSONObject.get((Object)"currency"));
    }

    @Test
    public void deleteByOwnerNonIssuer() {
        APICall aPICall = new TestCurrencyIssuance.Builder().naming("yjwcv", "YJWCV", "test1").build();
        TestCurrencyIssuance.issueCurrencyApi(aPICall);
        DeleteCurrencyTest.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("code", "YJWCV").build();
        JSONObject jSONObject = aPICall.invoke();
        String string = (String)jSONObject.get((Object)"currency");
        String string2 = (String)jSONObject.get((Object)"code");
        aPICall = new APICall.Builder("transferCurrency").secretPhrase(ALICE.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("recipient", Long.toUnsignedString(BOB.getId())).param("currency", string).param("unitsQNT", (String)jSONObject.get((Object)"maxSupplyQNT")).build();
        jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("transferCurrencyResponse:" + jSONObject));
        DeleteCurrencyTest.generateBlock();
        aPICall = new APICall.Builder("deleteCurrency").secretPhrase(BOB.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).build();
        jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("deleteCurrencyResponse:" + jSONObject));
        DeleteCurrencyTest.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("code", string2).build();
        jSONObject = aPICall.invoke();
        Assert.assertEquals((Object)5L, (Object)jSONObject.get((Object)"errorCode"));
        Assert.assertEquals((Object)"Unknown currency", (Object)jSONObject.get((Object)"errorDescription"));
        aPICall = new TestCurrencyIssuance.Builder().naming("yjwcv", "YJWCV", "test1").build();
        TestCurrencyIssuance.issueCurrencyApi(aPICall);
        DeleteCurrencyTest.generateBlock();
        aPICall = new APICall.Builder("getCurrency").param("code", "YJWCV").build();
        jSONObject = aPICall.invoke();
        String string3 = (String)jSONObject.get((Object)"currency");
        String string4 = (String)jSONObject.get((Object)"code");
        Assert.assertNotEquals((Object)string, (Object)string3);
        Assert.assertEquals((Object)string2, (Object)string4);
    }
}

