/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.monetarysystem;

import nxt.AccountCurrencyBalance;
import nxt.BlockchainTest;
import nxt.Tester;
import nxt.blockchain.Chain;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.ms.CurrencyType;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestCurrencyExchange
extends BlockchainTest {
    @Test
    public void buyCurrency() {
        APICall aPICall = new TestCurrencyIssuance.Builder().type(CurrencyType.EXCHANGEABLE.getCode()).build();
        String string = TestCurrencyIssuance.issueCurrencyApi(aPICall);
        AccountCurrencyBalance accountCurrencyBalance = new AccountCurrencyBalance(ALICE.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        AccountCurrencyBalance accountCurrencyBalance2 = new AccountCurrencyBalance(BOB.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((long)100000L, (long)accountCurrencyBalance.getCurrencyUnits());
        Assert.assertEquals((long)100000L, (long)accountCurrencyBalance.getUnconfirmedCurrencyUnits());
        JSONObject jSONObject = this.publishExchangeOffer(string);
        TestCurrencyExchange.generateBlock();
        APICall aPICall2 = new APICall.Builder("getBuyOffers").param("currency", string).build();
        JSONObject jSONObject2 = aPICall2.invoke();
        Logger.logDebugMessage((String)("getAllOffersResponse:" + jSONObject2.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"offers");
        Assert.assertEquals((Object)Tester.responseToStringId(jSONObject), (Object)((JSONObject)jSONArray.get(0)).get((Object)"offer"));
        AccountCurrencyBalance accountCurrencyBalance3 = new AccountCurrencyBalance(ALICE.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((Object)new AccountCurrencyBalance(-95000L - ChildChain.IGNIS.ONE_COIN, -ChildChain.IGNIS.ONE_COIN, -500L, 0L), (Object)accountCurrencyBalance3.diff(accountCurrencyBalance));
        aPICall2 = new APICall.Builder("currencyBuy").secretPhrase(BOB.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).param("rateNQTPerUnit", "106").param("unitsQNT", "200").build();
        JSONObject jSONObject3 = aPICall2.invoke();
        Logger.logDebugMessage((String)("currencyExchangeResponse:" + jSONObject3));
        TestCurrencyExchange.generateBlock();
        AccountCurrencyBalance accountCurrencyBalance4 = new AccountCurrencyBalance(ALICE.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((Object)new AccountCurrencyBalance(2000L, 21000L, 0L, -200L), (Object)accountCurrencyBalance4.diff(accountCurrencyBalance3));
        AccountCurrencyBalance accountCurrencyBalance5 = new AccountCurrencyBalance(BOB.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((Object)new AccountCurrencyBalance(-21000L - ChildChain.IGNIS.ONE_COIN, -21000L - ChildChain.IGNIS.ONE_COIN, 200L, 200L), (Object)accountCurrencyBalance5.diff(accountCurrencyBalance2));
        aPICall2 = new APICall.Builder("getAllExchanges").build();
        JSONObject jSONObject4 = aPICall2.invoke();
        Logger.logDebugMessage((String)("getAllExchangesResponse: " + jSONObject4));
        JSONArray jSONArray2 = (JSONArray)jSONObject4.get((Object)"exchanges");
        JSONObject jSONObject5 = (JSONObject)jSONArray2.get(0);
        Assert.assertEquals((Object)"105", (Object)jSONObject5.get((Object)"rateNQTPerUnit"));
        Assert.assertEquals((Object)"200", (Object)jSONObject5.get((Object)"unitsQNT"));
        Assert.assertEquals((Object)string, (Object)jSONObject5.get((Object)"currency"));
        Assert.assertEquals((long)accountCurrencyBalance.getAccountId(), (long)Convert.parseUnsignedLong((String)((String)jSONObject5.get((Object)"seller"))));
        Assert.assertEquals((long)accountCurrencyBalance2.getAccountId(), (long)Convert.parseUnsignedLong((String)((String)jSONObject5.get((Object)"buyer"))));
    }

    @Test
    public void sellCurrency() {
        APICall aPICall = new TestCurrencyIssuance.Builder().type(CurrencyType.EXCHANGEABLE.getCode()).build();
        String string = TestCurrencyIssuance.issueCurrencyApi(aPICall);
        AccountCurrencyBalance accountCurrencyBalance = new AccountCurrencyBalance(ALICE.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        AccountCurrencyBalance accountCurrencyBalance2 = new AccountCurrencyBalance(BOB.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((long)100000L, (long)accountCurrencyBalance.getCurrencyUnits());
        Assert.assertEquals((long)100000L, (long)accountCurrencyBalance.getUnconfirmedCurrencyUnits());
        JSONObject jSONObject = this.publishExchangeOffer(string);
        TestCurrencyExchange.generateBlock();
        APICall aPICall2 = new APICall.Builder("getSellOffers").param("currency", string).build();
        JSONObject jSONObject2 = aPICall2.invoke();
        Logger.logDebugMessage((String)("getAllOffersResponse:" + jSONObject2.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"offers");
        Assert.assertEquals((Object)Tester.responseToStringId(jSONObject), (Object)((JSONObject)jSONArray.get(0)).get((Object)"offer"));
        AccountCurrencyBalance accountCurrencyBalance3 = new AccountCurrencyBalance(ALICE.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((Object)new AccountCurrencyBalance(-95000L - ChildChain.IGNIS.ONE_COIN, -ChildChain.IGNIS.ONE_COIN, -500L, 0L), (Object)accountCurrencyBalance3.diff(accountCurrencyBalance));
        aPICall2 = new APICall.Builder("transferCurrency").secretPhrase(ALICE.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).param("recipient", Long.toUnsignedString(accountCurrencyBalance2.getAccountId())).param("unitsQNT", "2000").build();
        aPICall2.invoke();
        TestCurrencyExchange.generateBlock();
        AccountCurrencyBalance accountCurrencyBalance4 = new AccountCurrencyBalance(ALICE.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((Object)new AccountCurrencyBalance(-ChildChain.IGNIS.ONE_COIN, -ChildChain.IGNIS.ONE_COIN, -2000L, -2000L), (Object)accountCurrencyBalance4.diff(accountCurrencyBalance3));
        AccountCurrencyBalance accountCurrencyBalance5 = new AccountCurrencyBalance(BOB.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((Object)new AccountCurrencyBalance(0L, 0L, 2000L, 2000L), (Object)accountCurrencyBalance5.diff(accountCurrencyBalance2));
        aPICall2 = new APICall.Builder("currencySell").secretPhrase(BOB.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).param("rateNQTPerUnit", "90").param("unitsQNT", "200").build();
        JSONObject jSONObject3 = aPICall2.invoke();
        Logger.logDebugMessage((String)("currencyExchangeResponse:" + jSONObject3));
        TestCurrencyExchange.generateBlock();
        AccountCurrencyBalance accountCurrencyBalance6 = new AccountCurrencyBalance(ALICE.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((Object)new AccountCurrencyBalance(0L, -19000L, 0L, 200L), (Object)accountCurrencyBalance6.diff(accountCurrencyBalance4));
        AccountCurrencyBalance accountCurrencyBalance7 = new AccountCurrencyBalance(BOB.getSecretPhrase(), string, (Chain)ChildChain.IGNIS);
        Assert.assertEquals((Object)new AccountCurrencyBalance(19000L - ChildChain.IGNIS.ONE_COIN, 19000L - ChildChain.IGNIS.ONE_COIN, -200L, -200L), (Object)accountCurrencyBalance7.diff(accountCurrencyBalance5));
        aPICall2 = new APICall.Builder("getAllExchanges").build();
        JSONObject jSONObject4 = aPICall2.invoke();
        Logger.logDebugMessage((String)("getAllExchangesResponse: " + jSONObject4));
        JSONArray jSONArray2 = (JSONArray)jSONObject4.get((Object)"exchanges");
        JSONObject jSONObject5 = (JSONObject)jSONArray2.get(0);
        Assert.assertEquals((Object)"95", (Object)jSONObject5.get((Object)"rateNQTPerUnit"));
        Assert.assertEquals((Object)"200", (Object)jSONObject5.get((Object)"unitsQNT"));
        Assert.assertEquals((Object)string, (Object)jSONObject5.get((Object)"currency"));
        Assert.assertEquals((long)accountCurrencyBalance2.getAccountId(), (long)Convert.parseUnsignedLong((String)((String)jSONObject5.get((Object)"seller"))));
        Assert.assertEquals((long)accountCurrencyBalance.getAccountId(), (long)Convert.parseUnsignedLong((String)((String)jSONObject5.get((Object)"buyer"))));
    }

    private JSONObject publishExchangeOffer(String string) {
        APICall aPICall = new APICall.Builder("publishExchangeOffer").secretPhrase(ALICE.getSecretPhrase()).feeNQT(ChildChain.IGNIS.ONE_COIN).param("deadline", "1440").param("currency", string).param("buyRateNQTPerUnit", "95").param("sellRateNQTPerUnit", "105").param("totalBuyLimitQNT", "10000").param("totalSellLimitQNT", "5000").param("initialBuySupplyQNT", "1000").param("initialSellSupplyQNT", "500").param("expirationHeight", "2147483647").build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("publishExchangeOfferResponse: " + jSONObject.toJSONString()));
        return jSONObject;
    }
}

