/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.monetarysystem;

import nxt.BlockchainTest;
import nxt.account.Account;
import nxt.blockchain.ChildChain;
import nxt.crypto.Crypto;
import nxt.http.APICall;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.ms.CurrencyType;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestCurrencyReserveAndClaim
extends BlockchainTest {
    @Test
    public void reserveIncrease() {
        APICall aPICall = new TestCurrencyIssuance.Builder().type(CurrencyType.RESERVABLE.getCode() | CurrencyType.EXCHANGEABLE.getCode()).issuanceHeight(6).minReservePerUnitNQT(1L).initialSupply(0L).reserveSupply(100000L).build();
        String string = TestCurrencyIssuance.issueCurrencyApi(aPICall);
        this.reserveIncreaseImpl(string, ALICE.getSecretPhrase(), BOB.getSecretPhrase());
    }

    @Test
    public void cancelCrowdFunding() {
        APICall aPICall = new TestCurrencyIssuance.Builder().type(CurrencyType.RESERVABLE.getCode() | CurrencyType.EXCHANGEABLE.getCode()).issuanceHeight(5).minReservePerUnitNQT(11L).initialSupply(0L).reserveSupply(100000L).build();
        String string = TestCurrencyIssuance.issueCurrencyApi(aPICall);
        long l = ALICE.getChainBalance(ChildChain.IGNIS.getId());
        long l2 = BOB.getChainBalance(ChildChain.IGNIS.getId());
        this.reserveIncreaseImpl(string, ALICE.getSecretPhrase(), BOB.getSecretPhrase());
        TestCurrencyReserveAndClaim.generateBlock();
        APICall aPICall2 = new APICall.Builder("getCurrencyFounders").param("currency", string).build();
        JSONObject jSONObject = aPICall2.invoke();
        Logger.logMessage((String)("getFoundersResponse: " + jSONObject));
        Assert.assertTrue((((JSONArray)jSONObject.get((Object)"founders")).size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)(l - ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainBalance(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(l2 - 2L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalance(ChildChain.IGNIS.getId()));
    }

    @Test
    public void crowdFundingDistribution() {
        APICall aPICall = new TestCurrencyIssuance.Builder().type(CurrencyType.RESERVABLE.getCode() | CurrencyType.EXCHANGEABLE.getCode()).initialSupply(0L).reserveSupply(100000L).issuanceHeight(5).minReservePerUnitNQT(10L).build();
        String string = TestCurrencyIssuance.issueCurrencyApi(aPICall);
        long l = ALICE.getChainBalance(ChildChain.IGNIS.getId());
        long l2 = BOB.getChainBalance(ChildChain.IGNIS.getId());
        this.reserveIncreaseImpl(string, ALICE.getSecretPhrase(), BOB.getSecretPhrase());
        TestCurrencyReserveAndClaim.generateBlock();
        Assert.assertEquals((long)20000L, (long)ALICE.getCurrencyUnits(Convert.parseAccountId((String)string)));
        Assert.assertEquals((long)80000L, (long)BOB.getCurrencyUnits(Convert.parseAccountId((String)string)));
        Assert.assertEquals((long)(l - ChildChain.IGNIS.ONE_COIN - 200000L + 1000000L), (long)ALICE.getChainBalance(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(l2 - 2L * ChildChain.IGNIS.ONE_COIN - 800000L), (long)BOB.getChainBalance(ChildChain.IGNIS.getId()));
    }

    @Test
    public void crowdFundingDistributionRounding() {
        APICall aPICall = new TestCurrencyIssuance.Builder().type(CurrencyType.RESERVABLE.getCode() | CurrencyType.EXCHANGEABLE.getCode()).initialSupply(0L).reserveSupply(24L).maxSupply(24L).issuanceHeight(5).minReservePerUnitNQT(10L).build();
        String string = TestCurrencyIssuance.issueCurrencyApi(aPICall);
        long l = ALICE.getChainBalance(ChildChain.IGNIS.getId());
        long l2 = BOB.getChainBalance(ChildChain.IGNIS.getId());
        long l3 = CHUCK.getChainBalance(ChildChain.IGNIS.getId());
        this.reserveIncreaseImpl(string, BOB.getSecretPhrase(), CHUCK.getSecretPhrase());
        TestCurrencyReserveAndClaim.generateBlock();
        Assert.assertEquals((long)4L, (long)BOB.getCurrencyUnits(Convert.parseAccountId((String)string)));
        Assert.assertEquals((long)19L, (long)CHUCK.getCurrencyUnits(Convert.parseAccountId((String)string)));
        Assert.assertEquals((long)1L, (long)ALICE.getCurrencyUnits(Convert.parseAccountId((String)string)));
        Assert.assertEquals((long)(l + 240L), (long)ALICE.getChainBalance(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(l2 - ChildChain.IGNIS.ONE_COIN - 48L), (long)BOB.getChainBalance(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(l3 - 2L * ChildChain.IGNIS.ONE_COIN - 192L), (long)CHUCK.getChainBalance(ChildChain.IGNIS.getId()));
        aPICall = new APICall.Builder("getCurrency").param("currency", string).build();
        JSONObject jSONObject = aPICall.invoke();
        Assert.assertEquals((Object)"24", (Object)jSONObject.get((Object)"currentSupplyQNT"));
    }

    private void reserveIncreaseImpl(String string, String string2, String string3) {
        APICall aPICall = new APICall.Builder("currencyReserveIncrease").secretPhrase(string2).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).param("amountPerUnitNQT", "2").build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("reserveIncreaseResponse: " + jSONObject));
        TestCurrencyReserveAndClaim.generateBlock();
        aPICall = new APICall.Builder("currencyReserveIncrease").secretPhrase(string3).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).param("amountPerUnitNQT", "3").build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("reserveIncreaseResponse: " + jSONObject));
        aPICall = new APICall.Builder("currencyReserveIncrease").secretPhrase(string3).feeNQT(ChildChain.IGNIS.ONE_COIN).param("currency", string).param("amountPerUnitNQT", "5").build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("reserveIncreaseResponse: " + jSONObject));
        TestCurrencyReserveAndClaim.generateBlock();
        aPICall = new APICall.Builder("getCurrencyFounders").param("currency", string).build();
        JSONObject jSONObject2 = aPICall.invoke();
        Logger.logMessage((String)("getFoundersResponse: " + jSONObject2));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"founders");
        JSONObject jSONObject3 = (JSONObject)jSONArray.get(0);
        Assert.assertTrue((Long.toUnsignedString(Account.getId((byte[])Crypto.getPublicKey((String)string2))).equals(jSONObject3.get((Object)"account")) || Long.toUnsignedString(Account.getId((byte[])Crypto.getPublicKey((String)string3))).equals(jSONObject3.get((Object)"account")) ? 1 : 0) != 0);
        Assert.assertTrue((String.valueOf(8L).equals(jSONObject3.get((Object)"amountPerUnitNQT")) || String.valueOf(2L).equals(jSONObject3.get((Object)"amountPerUnitNQT")) ? 1 : 0) != 0);
        JSONObject jSONObject4 = (JSONObject)jSONArray.get(1);
        Assert.assertTrue((Long.toUnsignedString(Account.getId((byte[])Crypto.getPublicKey((String)string2))).equals(jSONObject4.get((Object)"account")) || Long.toUnsignedString(Account.getId((byte[])Crypto.getPublicKey((String)string3))).equals(jSONObject4.get((Object)"account")) ? 1 : 0) != 0);
        Assert.assertTrue((String.valueOf(8L).equals(jSONObject4.get((Object)"amountPerUnitNQT")) || String.valueOf(2L).equals(jSONObject4.get((Object)"amountPerUnitNQT")) ? 1 : 0) != 0);
    }
}

