/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.shuffling;

import nxt.BlockchainTest;
import nxt.Tester;
import nxt.account.HoldingType;
import nxt.addons.JO;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.util.Convert;
import nxt.util.Logger;
import org.json.simple.JSONObject;

public class ShufflingUtil {
    public static final Tester ALICE_RECIPIENT = new Tester("oiketrdgfxyjqhwds");
    public static final Tester BOB_RECIPIENT = new Tester("5ehtrd9oijnkter");
    public static final Tester CHUCK_RECIPIENT = new Tester("sdfxbejytdgfqrwefsrd");
    public static final Tester DAVE_RECIPIENT = new Tester("gh-=e49rsiufzn4^");
    static final long defaultShufflingAmount = 1500000000L;
    static final long defaultHoldingShufflingAmount = 40000L;
    static long shufflingAsset;
    static long shufflingCurrency;
    static final int chainId;
    static final long SHUFFLING_REGISTER_FEE;
    static final long SHUFFLING_PROCESSING_FEE;
    static final long SHUFFLING_TOTAL_FEE;
    static final long SHUFFLING_RECIPIENTS_FEE;

    static JO create(Tester tester) {
        return ShufflingUtil.create(tester, 4);
    }

    public static JO create(Tester tester, int n) {
        APICall aPICall = new APICall.Builder("shufflingCreate").secretPhrase(tester.getSecretPhrase()).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).param("amount", String.valueOf(1500000000L)).param("participantCount", String.valueOf(n)).param("registrationPeriod", 10).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("shufflingCreateResponse: " + jSONObject.toJSONString()));
        return JO.valueOf((Object)jSONObject);
    }

    static JSONObject createAssetShuffling(Tester tester) {
        APICall aPICall = new APICall.Builder("issueAsset").param("secretPhrase", tester.getSecretPhrase()).param("name", "phased").param("description", "shuffling transaction testing").param("quantityQNT", 1000000).param("decimals", 2).param("feeNQT", 1000L * ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build();
        JSONObject jSONObject = aPICall.invoke();
        shufflingAsset = Long.parseUnsignedLong(Tester.responseToStringId(jSONObject));
        BlockchainTest.generateBlock();
        aPICall = new APICall.Builder("transferAsset").param("secretPhrase", tester.getSecretPhrase()).param("recipient", BlockchainTest.BOB.getRsAccount()).param("asset", Long.toUnsignedString(shufflingAsset)).param("quantityQNT", 100000).param("feeNQT", ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("transferAssetResponse: " + jSONObject.toJSONString()));
        aPICall = new APICall.Builder("transferAsset").param("secretPhrase", tester.getSecretPhrase()).param("recipient", BlockchainTest.CHUCK.getRsAccount()).param("asset", Long.toUnsignedString(shufflingAsset)).param("quantityQNT", 100000).param("feeNQT", ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("transferAssetResponse: " + jSONObject.toJSONString()));
        aPICall = new APICall.Builder("transferAsset").param("secretPhrase", tester.getSecretPhrase()).param("recipient", BlockchainTest.DAVE.getRsAccount()).param("asset", Long.toUnsignedString(shufflingAsset)).param("quantityQNT", 100000).param("feeNQT", ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("transferAssetResponse: " + jSONObject.toJSONString()));
        BlockchainTest.generateBlock();
        aPICall = new APICall.Builder("shufflingCreate").secretPhrase(tester.getSecretPhrase()).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).param("amount", String.valueOf(40000L)).param("participantCount", "4").param("registrationPeriod", 10).param("holding", Long.toUnsignedString(shufflingAsset)).param("holdingType", String.valueOf(HoldingType.ASSET.getCode())).build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("shufflingCreateResponse: " + jSONObject.toJSONString()));
        return jSONObject;
    }

    static JSONObject createCurrencyShuffling(Tester tester) {
        APICall aPICall = new APICall.Builder("issueCurrency").param("secretPhrase", tester.getSecretPhrase()).param("name", "shfle").param("code", "SHFL").param("description", "phased transaction testing").param("type", 1).param("initialSupplyQNT", 10000000).param("maxSupplyQNT", 10000000).param("decimals", 2).param("feeNQT", 1000L * ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build();
        JSONObject jSONObject = aPICall.invoke();
        shufflingCurrency = Long.parseUnsignedLong(Tester.responseToStringId(jSONObject));
        BlockchainTest.generateBlock();
        aPICall = new APICall.Builder("transferCurrency").param("secretPhrase", tester.getSecretPhrase()).param("recipient", BlockchainTest.BOB.getRsAccount()).param("currency", Long.toUnsignedString(shufflingCurrency)).param("unitsQNT", 100000).param("feeNQT", ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("transferCurrencyResponse: " + jSONObject.toJSONString()));
        aPICall = new APICall.Builder("transferCurrency").param("secretPhrase", tester.getSecretPhrase()).param("recipient", BlockchainTest.CHUCK.getRsAccount()).param("currency", Long.toUnsignedString(shufflingCurrency)).param("unitsQNT", 100000).param("feeNQT", ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("transferCurrencyResponse: " + jSONObject.toJSONString()));
        aPICall = new APICall.Builder("transferCurrency").param("secretPhrase", tester.getSecretPhrase()).param("recipient", BlockchainTest.DAVE.getRsAccount()).param("currency", Long.toUnsignedString(shufflingCurrency)).param("unitsQNT", 100000).param("feeNQT", ChildChain.IGNIS.ONE_COIN).param("deadline", 1440).build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("transferCurrencyResponse: " + jSONObject.toJSONString()));
        BlockchainTest.generateBlock();
        aPICall = new APICall.Builder("shufflingCreate").secretPhrase(tester.getSecretPhrase()).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).param("amount", String.valueOf(40000L)).param("participantCount", "4").param("registrationPeriod", 10).param("holding", Long.toUnsignedString(shufflingCurrency)).param("holdingType", String.valueOf(HoldingType.CURRENCY.getCode())).build();
        jSONObject = aPICall.invoke();
        Logger.logMessage((String)("shufflingCreateResponse: " + jSONObject.toJSONString()));
        return jSONObject;
    }

    static JSONObject register(String string, Tester tester) {
        APICall aPICall = new APICall.Builder("shufflingRegister").secretPhrase(tester.getSecretPhrase()).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).param("shufflingFullHash", string).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("shufflingRegisterResponse: " + jSONObject.toJSONString()));
        return jSONObject;
    }

    public static JO getShuffling(String string) {
        APICall aPICall = new APICall.Builder("getShuffling").param("shufflingFullHash", string).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("getShufflingResponse: " + jSONObject.toJSONString()));
        return JO.valueOf((Object)jSONObject);
    }

    public static JO getShufflingParticipants(String string) {
        APICall aPICall = new APICall.Builder("getShufflingParticipants").param("shufflingFullHash", string).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("getShufflingParticipantsResponse: " + jSONObject.toJSONString()));
        return JO.valueOf((Object)jSONObject);
    }

    static JSONObject process(String string, Tester tester, Tester tester2) {
        return ShufflingUtil.process(string, tester, tester2, true);
    }

    static JSONObject process(String string, Tester tester, Tester tester2, boolean bl) {
        APICall.Builder builder = new APICall.Builder("shufflingProcess").param("shufflingFullHash", string).param("secretPhrase", tester.getSecretPhrase()).param("recipientSecretPhrase", tester2.getSecretPhrase()).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN);
        if (!bl) {
            builder.param("broadcast", "false");
        }
        APICall aPICall = builder.build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("shufflingProcessResponse: " + jSONObject.toJSONString()));
        return jSONObject;
    }

    static JSONObject verify(String string, Tester tester, String string2) {
        APICall aPICall = new APICall.Builder("shufflingVerify").param("shufflingFullHash", string).param("secretPhrase", tester.getSecretPhrase()).param("shufflingStateHash", string2).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("shufflingVerifyResponse:" + jSONObject));
        return jSONObject;
    }

    static JSONObject cancel(String string, Tester tester, String string2, long l) {
        return ShufflingUtil.cancel(string, tester, string2, l, true);
    }

    static JSONObject cancel(String string, Tester tester, String string2, long l, boolean bl) {
        APICall.Builder builder = new APICall.Builder("shufflingCancel").param("shufflingFullHash", string).param("secretPhrase", tester.getSecretPhrase()).param("shufflingStateHash", string2).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN);
        if (l != 0L) {
            builder.param("cancellingAccount", Long.toUnsignedString(l));
        }
        if (!bl) {
            builder.param("broadcast", "false");
        }
        APICall aPICall = builder.build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logDebugMessage((String)("shufflingCancelResponse:" + jSONObject));
        return jSONObject;
    }

    static JSONObject broadcast(JSONObject jSONObject, Tester tester) {
        jSONObject.remove((Object)"signature");
        APICall aPICall = new APICall.Builder("signTransaction").param("unsignedTransactionJSON", jSONObject.toJSONString()).param("validate", "false").param("secretPhrase", tester.getSecretPhrase()).build();
        JSONObject jSONObject2 = aPICall.invoke();
        if (jSONObject2.get((Object)"transactionJSON") == null) {
            return jSONObject2;
        }
        aPICall = new APICall.Builder("broadcastTransaction").param("transactionJSON", ((JSONObject)jSONObject2.get((Object)"transactionJSON")).toJSONString()).build();
        jSONObject2 = aPICall.invoke();
        Logger.logDebugMessage((String)("broadcastTransactionResponse:" + jSONObject2));
        return jSONObject2;
    }

    public static JSONObject startShuffler(Tester tester, Tester tester2, String string) {
        APICall aPICall = new APICall.Builder("startShuffler").secretPhrase(tester.getSecretPhrase()).param("recipientPublicKey", Convert.toHexString((byte[])tester2.getPublicKey())).param("shufflingFullHash", string).param("feeRateNQTPerFXT", ChildChain.IGNIS.ONE_COIN).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("startShufflerResponse: " + jSONObject.toJSONString()));
        return jSONObject;
    }

    static JSONObject stopShuffler(Tester tester, String string) {
        APICall aPICall = new APICall.Builder("stopShuffler").secretPhrase(tester.getSecretPhrase()).param("shufflingFullHash", string).build();
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("stopShufflerResponse: " + jSONObject.toJSONString()));
        return jSONObject;
    }

    static JSONObject sendMoney(Tester tester, Tester tester2, long l) {
        JSONObject jSONObject = new APICall.Builder("sendMoney").param("secretPhrase", tester.getSecretPhrase()).param("recipient", tester2.getStrId()).param("amountNQT", l * ChildChain.IGNIS.ONE_COIN).feeRateNQTPerFXT(ChildChain.IGNIS.ONE_COIN).build().invoke();
        Logger.logMessage((String)("sendMoneyResponse: " + jSONObject.toJSONString()));
        return jSONObject;
    }

    private ShufflingUtil() {
    }

    static {
        chainId = ChildChain.IGNIS.getId();
        SHUFFLING_REGISTER_FEE = ChildChain.IGNIS.ONE_COIN / 100L;
        SHUFFLING_PROCESSING_FEE = ChildChain.IGNIS.ONE_COIN / 10L;
        SHUFFLING_TOTAL_FEE = 2L * SHUFFLING_REGISTER_FEE + SHUFFLING_PROCESSING_FEE;
        SHUFFLING_RECIPIENTS_FEE = ChildChain.IGNIS.ONE_COIN * 11L / 100L;
    }
}

