/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import java.util.List;
import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.crypto.HashFunction;
import nxt.http.APICall;
import nxt.http.accountControl.ACTestUtils;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.http.twophased.TestApproveTransaction;
import nxt.http.twophased.TestPropertyVoting;
import nxt.util.Convert;
import nxt.util.JSONAssert;
import nxt.util.Logger;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestCompositeVoting
extends BlockchainTest {
    @Test
    public void testWhitelistAndByHash() {
        String string = "test secret";
        JSONObject jSONObject = this.createPhasedWhiteListAndByHash(string, BOB);
        Object object = jSONObject.get((Object)"fullHash");
        TestCompositeVoting.approve(object, CHUCK, null);
        TestCompositeVoting.generateBlocks(4);
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.REJECTED), (Object)((Object)ACTestUtils.getPhasingStatus(object)));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        string = "test secret 1";
        jSONObject = this.createPhasedWhiteListAndByHash(string, BOB);
        object = jSONObject.get((Object)"fullHash");
        TestCompositeVoting.approve(object, DAVE, string);
        TestCompositeVoting.generateBlocks(4);
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.REJECTED), (Object)((Object)ACTestUtils.getPhasingStatus(object)));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        jSONObject = this.createPhasedWhiteListAndByHash(string, BOB);
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), DAVE, string);
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), CHUCK, null);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testWhitelistedMoreThanOnce() {
        String string = "test abcd";
        APICall.Builder builder = this.createWhitelistAndHashBuilder(BOB, string);
        JSONObject jSONObject = builder.param("phasingExpression", "A & B & C & D").param("phasingCVotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode()).param("phasingCWhitelisted", CHUCK.getStrId()).param("phasingCQuorum", 1).param("phasingDVotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode()).param("phasingDWhitelisted", CHUCK.getStrId()).param("phasingDQuorum", 1).build().invoke();
        Assert.assertNull((Object)jSONObject.get((Object)"error"));
        TestCompositeVoting.generateBlock();
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), CHUCK, null);
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), DAVE, string);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testSameSecretInTwoSubPolls() {
        String string = "test abcd";
        String string2 = Convert.toHexString((byte[])HashFunction.SHA256.hash(string.getBytes()));
        APICall.Builder builder = this.createWhitelistAndHashBuilder(BOB, string);
        JSONObject jSONObject = builder.param("phasingExpression", "A & B & C").param("phasingCVotingModel", VoteWeighting.VotingModel.HASH.getCode()).param("phasingCQuorum", 1).param("phasingCHashedSecret", string2).param("phasingCHashedSecretAlgorithm", HashFunction.SHA256.getId()).build().invoke();
        Assert.assertNull((Object)jSONObject.get((Object)"error"));
        TestCompositeVoting.generateBlock();
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), CHUCK, null);
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), DAVE, string);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testTwoSecretsApproveAtOnce() {
        String string = "test A";
        String string2 = "test B";
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        long l = 100L * ChildChain.IGNIS.ONE_COIN;
        phasingBuilder.setParamValidation(false).feeNQT(4L * ChildChain.IGNIS.ONE_COIN).param("recipient", BOB.getStrId()).param("amountNQT", l);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.COMPOSITE).quorum(1).phasingParam("Expression", "A & B");
        phasingBuilder.startSubPoll("A").votingModel(VoteWeighting.VotingModel.HASH).hashedSecret(string, HashFunction.SHA256).quorum(1);
        phasingBuilder.startSubPoll("B").votingModel(VoteWeighting.VotingModel.HASH).hashedSecret(string2, HashFunction.SHA256).quorum(1);
        String string3 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestCompositeVoting.generateBlock();
        APICall.Builder builder = ACTestUtils.approveBuilder(string3, CHUCK, string);
        builder.param("revealedSecretText", new String[]{string, string2});
        new JSONAssert(builder.build().invoke()).str("fullHash");
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)l, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testAssetAndCurrency() {
        TestCompositeVoting.generateBlocks(4);
        String string = this.distributeCurrency(100L);
        String string2 = this.distributeAsset(100L);
        JSONObject jSONObject = this.createPhasedAssetAndCurrency(DAVE, string2, string);
        Object object = jSONObject.get((Object)"fullHash");
        TestCompositeVoting.approve(object, BOB, null);
        TestCompositeVoting.generateBlocks(4);
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.REJECTED), (Object)((Object)ACTestUtils.getPhasingStatus(object)));
        Assert.assertEquals((long)0L, (long)DAVE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        jSONObject = this.createPhasedAssetAndCurrency(DAVE, string2, string);
        object = jSONObject.get((Object)"fullHash");
        TestCompositeVoting.approve(object, CHUCK, null);
        TestCompositeVoting.generateBlocks(4);
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.REJECTED), (Object)((Object)ACTestUtils.getPhasingStatus(object)));
        Assert.assertEquals((long)0L, (long)DAVE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        jSONObject = this.createPhasedAssetAndCurrency(DAVE, string2, string);
        object = jSONObject.get((Object)"fullHash");
        TestCompositeVoting.approve(object, BOB, null);
        TestCompositeVoting.approve(object, CHUCK, null);
        TestCompositeVoting.generateBlocks(1);
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.PENDING), (Object)((Object)ACTestUtils.getPhasingStatus(object)));
        Assert.assertEquals((long)0L, (long)DAVE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlocks(3);
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)DAVE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        jSONObject = this.createPhasedAssetAndCurrency(DAVE, string2, string);
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), ALICE, null);
        TestCompositeVoting.generateBlocks(4);
        Assert.assertEquals((long)(200L * ChildChain.IGNIS.ONE_COIN), (long)DAVE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testNegatedWhitelist() {
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        JSONObject jSONObject = this.createWhitelistNegated(BOB, l);
        Object object = jSONObject.get((Object)"fullHash");
        TestCompositeVoting.generateBlocks(3);
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.PENDING), (Object)((Object)ACTestUtils.getPhasingStatus(object)));
        Assert.assertEquals((long)0L, (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        jSONObject = this.createWhitelistNegated(DAVE, l);
        object = jSONObject.get((Object)"fullHash");
        TestCompositeVoting.approve(object, CHUCK, null);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.REJECTED), (Object)((Object)ACTestUtils.getPhasingStatus(object)));
        Assert.assertEquals((long)(-l), (long)DAVE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void xorApprovalNoApproval() {
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        this.createXorWhitelist(BOB, l);
        TestCompositeVoting.generateBlocks(3);
        Assert.assertEquals((long)0L, (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)0L, (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-l), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void xorApprovalBothApprove() {
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        JSONObject jSONObject = this.createXorWhitelist(BOB, l);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)0L, (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), CHUCK, null);
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), DAVE, null);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)0L, (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-l), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void xorApprovalChuckApproves() {
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        JSONObject jSONObject = this.createXorWhitelist(BOB, l);
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), CHUCK, null);
        TestCompositeVoting.generateBlocks(3);
        Assert.assertEquals((long)0L, (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void xorApprovalDaveApproves() {
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        JSONObject jSONObject = this.createXorWhitelist(BOB, l);
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), CHUCK, null);
        TestCompositeVoting.generateBlocks(3);
        Assert.assertEquals((long)0L, (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)ALICE.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)BOB.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testNegatedAssetApproved() {
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        this.createPhasedByAssetNegated(BOB, CHUCK, l);
        TestCompositeVoting.generateBlocks(4);
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)CHUCK.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testNegatedAssetRejected() {
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        JSONObject jSONObject = this.createPhasedByAssetNegated(DAVE, CHUCK, l);
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), BOB, null);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)0L, (long)CHUCK.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        Assert.assertEquals((long)(-100L * ChildChain.IGNIS.ONE_COIN - l), (long)DAVE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlocks(3);
        Assert.assertEquals((long)(-l), (long)DAVE.getChainUnconfirmedBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testByPropertyAndNone() {
        String string = "prop3";
        String string2 = "prop_val";
        APICall.Builder builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, string2);
        builder.build().invoke();
        TestCompositeVoting.generateBlock();
        builder = this.createGenericBuilder(ALICE, BOB, 3L * ChildChain.IGNIS.ONE_COIN);
        builder.param("phasingExpression", "A & N");
        builder.param("phasingAVotingModel", VoteWeighting.VotingModel.PROPERTY.getCode());
        builder.param("phasingAQuorum", 1);
        builder.param("phasingASenderPropertySetter", CHUCK.getStrId());
        builder.param("phasingASenderPropertyName", string);
        builder.param("phasingASenderPropertyValue", string2);
        builder.param("phasingNVotingModel", VoteWeighting.VotingModel.NONE.getCode());
        builder.build().invoke();
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlocks(4);
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testNoEarlyFinish() {
        ACTestUtils.PhasingBuilder phasingBuilder = this.createGenericBuilder(ALICE, BOB, 3L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder.param("phasingExpression", "A & N");
        phasingBuilder.param("phasingAVotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode());
        phasingBuilder.param("phasingAWhitelisted", CHUCK.getStrId());
        phasingBuilder.param("phasingAQuorum", 1);
        phasingBuilder.param("phasingNVotingModel", VoteWeighting.VotingModel.NONE.getCode());
        phasingBuilder.build().invoke();
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlocks(4);
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        phasingBuilder.param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + 5);
        JSONObject jSONObject = phasingBuilder.build().invoke();
        TestCompositeVoting.generateBlock();
        TestCompositeVoting.approve(jSONObject.get((Object)"fullHash"), CHUCK, null);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlocks(3);
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testByTwoProperties() {
        APICall.Builder builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, "a", "b");
        builder.build().invoke();
        builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, "c", "d");
        builder.build().invoke();
        TestCompositeVoting.generateBlock();
        ACTestUtils.PhasingBuilder phasingBuilder = this.createGenericBuilder(ALICE, BOB, 4L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.COMPOSITE).quorum(1).phasingParam("Expression", "A & B");
        phasingBuilder.startSubPoll("A").votingModel(VoteWeighting.VotingModel.PROPERTY).property("Sender", CHUCK, "a", "b").quorum(1);
        phasingBuilder.startSubPoll("B").votingModel(VoteWeighting.VotingModel.PROPERTY).property("Sender", CHUCK, "c", "d").quorum(1);
        String string = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        APICall.Builder builder2 = new APICall.Builder("getPhasingPoll").param("transactionFullHash", string).param("countVotes", "true");
        JSONAssert jSONAssert = new JSONAssert(builder2.build().invoke());
        Assert.assertEquals((Object)"1", (Object)jSONAssert.str("result"));
    }

    @Test
    public void testCompositeVotingNotAcceptingSecret() {
        ACTestUtils.PhasingBuilder phasingBuilder = this.createGenericBuilder(ALICE, BOB, 4L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.COMPOSITE).quorum(1).phasingParam("Expression", "A & B");
        phasingBuilder.startSubPoll("A").votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK).quorum(1);
        phasingBuilder.startSubPoll("B").votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(DAVE).quorum(1);
        String string = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestCompositeVoting.generateBlock();
        APICall.Builder builder = ACTestUtils.approveBuilder(string, CHUCK, "some secret");
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        Assert.assertEquals((Object)String.format("Phased transaction %s:%s does not accept by-hash voting", ChildChain.IGNIS.getId(), string), (Object)jSONAssert.str("errorDescription"));
    }

    @Test
    public void testEarlyFinishOfTransactionVoting() {
        JSONAssert jSONAssert = new JSONAssert(TestApproveTransaction.getSignedBytes());
        String string = jSONAssert.str("fullHash");
        String string2 = jSONAssert.str("transactionBytes");
        jSONAssert = new JSONAssert(TestApproveTransaction.getSignedBytes());
        String string3 = jSONAssert.str("fullHash");
        String string4 = jSONAssert.str("transactionBytes");
        ACTestUtils.PhasingBuilder phasingBuilder = this.createGenericBuilder(ALICE, BOB, 4L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.COMPOSITE).quorum(1).phasingParam("Expression", "T1 & T2");
        phasingBuilder.startSubPoll("T1").votingModel(VoteWeighting.VotingModel.TRANSACTION).phasingParam("LinkedTransaction", ChildChain.IGNIS.getId() + ":" + string).quorum(1);
        phasingBuilder.startSubPoll("T2").votingModel(VoteWeighting.VotingModel.TRANSACTION).phasingParam("LinkedTransaction", ChildChain.IGNIS.getId() + ":" + string3).quorum(1);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestCompositeVoting.generateBlock();
        new APICall.Builder("broadcastTransaction").param("transactionBytes", string2).build().invoke();
        new APICall.Builder("broadcastTransaction").param("transactionBytes", string4).build().invoke();
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testLinkedTransactionsGrouping() {
        JSONAssert jSONAssert = new JSONAssert(TestApproveTransaction.getSignedBytes());
        String string = jSONAssert.str("fullHash");
        String string2 = jSONAssert.str("transactionBytes");
        ACTestUtils.PhasingBuilder phasingBuilder = this.createGenericBuilder(ALICE, BOB, 4L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.COMPOSITE).quorum(1).phasingParam("Expression", "T1 & T2");
        phasingBuilder.startSubPoll("T1").votingModel(VoteWeighting.VotingModel.TRANSACTION).phasingParam("LinkedTransaction", ChildChain.IGNIS.getId() + ":" + string).quorum(1);
        phasingBuilder.startSubPoll("T2").votingModel(VoteWeighting.VotingModel.TRANSACTION).phasingParam("LinkedTransaction", ChildChain.IGNIS.getId() + ":" + string).quorum(1);
        String string3 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestCompositeVoting.generateBlock();
        APICall.Builder builder = new APICall.Builder("getLinkedPhasedTransactions").param("linkedFullHash", string);
        List<JSONObject> list = new JSONAssert(builder.build().invoke()).array("transactions", JSONObject.class);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)string3, (Object)new JSONAssert(list.get(0)).str("fullHash"));
        new APICall.Builder("broadcastTransaction").param("transactionBytes", string2).build().invoke();
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testWhitelistedCoinVoting() {
        ACTestUtils.PhasingBuilder phasingBuilder = this.createGenericBuilder(ALICE, BOB, 4L * ChildChain.IGNIS.ONE_COIN);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.COMPOSITE).quorum(1).phasingParam("Expression", "A1 & A2");
        phasingBuilder.startSubPoll("A1").votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK, DAVE).quorum(2);
        phasingBuilder.startSubPoll("A2").votingModel(VoteWeighting.VotingModel.COIN).whitelist(DAVE).quorum(DAVE.getInitialChainBalance(ChildChain.IGNIS.getId()) + 1L);
        String string = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestCompositeVoting.generateBlock();
        APICall.Builder builder = new APICall.Builder("getVoterPhasedTransactions").param("account", DAVE.getStrId());
        List<JSONObject> list = new JSONAssert(builder.build().invoke()).array("transactions", JSONObject.class);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)string, (Object)new JSONAssert(list.get(0)).str("fullHash"));
        TestCompositeVoting.approve(string, CHUCK, null);
        TestCompositeVoting.approve(string, DAVE, null);
        TestCompositeVoting.generateBlocks(4);
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        phasingBuilder.whitelist(CHUCK, DAVE);
        phasingBuilder.param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + 5);
        string = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestCompositeVoting.generateBlock();
        TestCompositeVoting.approve(string, CHUCK, null);
        TestCompositeVoting.approve(string, DAVE, null);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        TestCompositeVoting.generateBlocks(3);
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testLongVariable() {
        APICall.Builder builder = this.createWhitelistAndHashBuilder(BOB, "a");
        String string = "Variable001";
        builder.param("phasingExpression", "A & " + string);
        builder.param("phasingAVotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode()).param("phasingAWhitelisted", CHUCK.getStrId()).param("phasingAQuorum", 1);
        builder.param("phasing" + string + "VotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode()).param("phasing" + string + "Whitelisted", CHUCK.getStrId()).param("phasing" + string + "Quorum", 1);
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").contains("Invalid variable name"));
    }

    @Test
    public void testLongExpression() {
        APICall.Builder builder = this.createWhitelistAndHashBuilder(BOB, "a");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 10; ++i) {
            String string = "Variable0" + i;
            stringBuilder.append(string).append(i < 9 ? " &" : "  ");
            for (int j = 12; j < 100; ++j) {
                stringBuilder.append(' ');
            }
            builder.param("phasing" + string + "VotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode()).param("phasing" + string + "Whitelisted", CHUCK.getStrId()).param("phasing" + string + "Quorum", 1);
        }
        builder.param("phasingExpression", stringBuilder.toString() + " ");
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").contains("Invalid boolean expression"));
        builder.param("phasingExpression", stringBuilder.toString());
        jSONAssert = new JSONAssert(builder.build().invoke());
        TestCompositeVoting.generateBlock();
        TestCompositeVoting.approve(jSONAssert.fullHash(), CHUCK, null);
        TestCompositeVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    private String distributeCurrency(long l) {
        TestCurrencyIssuance.Builder builder = new ACTestUtils.CurrencyBuilder().naming("CompositeV", "TCOMV", "Test Composite Voting");
        String string = Tester.responseToStringId(ACTestUtils.assertTransactionSuccess(builder));
        TestCompositeVoting.generateBlock();
        builder = new APICall.Builder("transferCurrency").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", CHUCK.getRsAccount()).param("currency", string).param("unitsQNT", l).param("feeNQT", ChildChain.IGNIS.ONE_COIN).param("deadline", 1440);
        ACTestUtils.assertTransactionSuccess(builder);
        BlockchainTest.generateBlock();
        return string;
    }

    private String distributeAsset(long l) {
        ACTestUtils.AssetBuilder assetBuilder = new ACTestUtils.AssetBuilder(ALICE.getSecretPhrase(), "CompositeV");
        String string = Tester.responseToStringId(ACTestUtils.assertTransactionSuccess(assetBuilder));
        TestCompositeVoting.generateBlock();
        assetBuilder = new APICall.Builder("transferAsset").param("secretPhrase", ALICE.getSecretPhrase()).param("recipient", BOB.getRsAccount()).param("asset", string).param("quantityQNT", l).param("feeNQT", ChildChain.IGNIS.ONE_COIN);
        ACTestUtils.assertTransactionSuccess(assetBuilder);
        BlockchainTest.generateBlock();
        return string;
    }

    private static JSONObject approve(Object object, Tester tester, String string) {
        return ACTestUtils.approve(object, tester, string);
    }

    private JSONObject createPhasedWhiteListAndByHash(String string, Tester tester) {
        JSONObject jSONObject = this.createWhitelistAndHashBuilder(tester, string).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        Assert.assertNull((Object)jSONObject.get((Object)"error"));
        TestCompositeVoting.generateBlock();
        return jSONObject;
    }

    private APICall.Builder createWhitelistAndHashBuilder(Tester tester, String string) {
        long l = 3L * ChildChain.IGNIS.ONE_COIN;
        String string2 = Convert.toHexString((byte[])HashFunction.SHA256.hash(string.getBytes()));
        Tester tester2 = ALICE;
        return this.createGenericBuilder(tester2, tester, l).param("phasingExpression", "A & B").param("phasingAVotingModel", VoteWeighting.VotingModel.HASH.getCode()).param("phasingAHashedSecret", string2).param("phasingAHashedSecretAlgorithm", HashFunction.SHA256.getId()).param("phasingAQuorum", 1).param("phasingBVotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode()).param("phasingBWhitelisted", CHUCK.getStrId()).param("phasingBQuorum", 1);
    }

    private ACTestUtils.PhasingBuilder createGenericBuilder(Tester tester, Tester tester2, long l) {
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", tester).votingModel(VoteWeighting.VotingModel.COMPOSITE).quorum(1);
        phasingBuilder.setParamValidation(false).param("recipient", tester2.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN).param("feeNQT", l);
        return phasingBuilder;
    }

    private JSONObject createPhasedAssetAndCurrency(Tester tester, String string, String string2) {
        long l = 6L * ChildChain.IGNIS.ONE_COIN;
        JSONObject jSONObject = this.createGenericBuilder(ALICE, tester, l).param("phasingExpression", "A & C").param("phasingAVotingModel", VoteWeighting.VotingModel.ASSET.getCode()).param("phasingAHolding", string).param("phasingAQuorum", 100).param("phasingCVotingModel", VoteWeighting.VotingModel.CURRENCY.getCode()).param("phasingCHolding", string2).param("phasingCQuorum", 100).build().invoke();
        Logger.logDebugMessage((String)("sendMoney: " + jSONObject));
        Assert.assertNull((Object)jSONObject.get((Object)"errorCode"));
        TestCompositeVoting.generateBlock();
        return jSONObject;
    }

    private JSONObject createWhitelistNegated(Tester tester, long l) {
        JSONObject jSONObject = this.createGenericBuilder(tester, ALICE, l).param("phasingExpression", "!A").param("phasingAVotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode()).param("phasingAWhitelisted", CHUCK.getStrId()).param("phasingAQuorum", 1).build().invoke();
        Assert.assertNull((Object)jSONObject.get((Object)"errorCode"));
        TestCompositeVoting.generateBlock();
        return jSONObject;
    }

    private JSONObject createXorWhitelist(Tester tester, long l) {
        JSONObject jSONObject = this.createGenericBuilder(tester, ALICE, l).param("phasingExpression", "A & !B | !A & B").param("phasingAVotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode()).param("phasingAWhitelisted", CHUCK.getStrId()).param("phasingAQuorum", 1).param("phasingBVotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode()).param("phasingBWhitelisted", DAVE.getStrId()).param("phasingBQuorum", 1).build().invoke();
        Assert.assertNull((Object)jSONObject.get((Object)"errorCode"));
        TestCompositeVoting.generateBlock();
        return jSONObject;
    }

    private JSONObject createPhasedByAssetNegated(Tester tester, Tester tester2, long l) {
        String string = this.distributeAsset(150L);
        JSONObject jSONObject = this.createGenericBuilder(tester, tester2, l).param("phasingExpression", "!A").param("phasingAVotingModel", VoteWeighting.VotingModel.ASSET.getCode()).param("phasingAHolding", string).param("phasingAQuorum", 150).build().invoke();
        Assert.assertNull((Object)jSONObject.get((Object)"errorCode"));
        TestCompositeVoting.generateBlock();
        return jSONObject;
    }
}

