/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import java.util.ArrayList;
import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.twophased.TestGetAccountPhasedTransactions;
import nxt.http.twophased.TwoPhasedSuite;
import nxt.util.Logger;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestCreateTwoPhased
extends BlockchainTest {
    static JSONObject issueCreateTwoPhased(APICall aPICall, boolean bl) {
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("two-phased sendMoney: " + jSONObject.toJSONString()));
        TestCreateTwoPhased.generateBlock();
        String string = (String)jSONObject.get((Object)"fullHash");
        if (!bl && string == null || bl && string != null) {
            Assert.fail();
        }
        return jSONObject;
    }

    @Test
    public void validMoneyTransfer() {
        APICall aPICall = new TwoPhasedMoneyTransferBuilder().build();
        TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
    }

    @Test
    public void invalidMoneyTransfer() {
        int n = Nxt.getBlockchain().getHeight();
        APICall aPICall = new TwoPhasedMoneyTransferBuilder().finishHeight(n).build();
        TestCreateTwoPhased.issueCreateTwoPhased(aPICall, true);
        aPICall = new TwoPhasedMoneyTransferBuilder().finishHeight(n + 100000).build();
        TestCreateTwoPhased.issueCreateTwoPhased(aPICall, true);
        aPICall = new TwoPhasedMoneyTransferBuilder().quorum(0).build();
        TestCreateTwoPhased.issueCreateTwoPhased(aPICall, true);
        aPICall = new TwoPhasedMoneyTransferBuilder().noWhitelist().build();
        TestCreateTwoPhased.issueCreateTwoPhased(aPICall, true);
        aPICall = new TwoPhasedMoneyTransferBuilder().whitelisted(0L).build();
        TestCreateTwoPhased.issueCreateTwoPhased(aPICall, true);
        aPICall = new TwoPhasedMoneyTransferBuilder().votingModel(VoteWeighting.VotingModel.ASSET.getCode()).build();
        TestCreateTwoPhased.issueCreateTwoPhased(aPICall, true);
        aPICall = new TwoPhasedMoneyTransferBuilder().votingModel(VoteWeighting.VotingModel.ASSET.getCode()).minBalance(50L, VoteWeighting.MinBalanceModel.ASSET.getCode()).build();
        TestCreateTwoPhased.issueCreateTwoPhased(aPICall, true);
    }

    @Test
    public void unconfirmed() {
        JSONObject jSONObject;
        APICall aPICall;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        for (int i = 0; i < 10; ++i) {
            aPICall = new TwoPhasedMoneyTransferBuilder().build();
            jSONObject = TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
            String string = (String)jSONObject.get((Object)"fullHash");
            arrayList.add(string);
        }
        APICall aPICall2 = new TwoPhasedMoneyTransferBuilder().build();
        aPICall2.invoke();
        aPICall = TestGetAccountPhasedTransactions.phasedTransactionsApiCall().invoke();
        Logger.logMessage((String)("getAccountPhasedTransactionsResponse:" + aPICall.toJSONString()));
        jSONObject = (JSONArray)aPICall.get((Object)"transactions");
        for (String string : arrayList) {
            Assert.assertTrue((boolean)TwoPhasedSuite.searchForTransactionId((JSONArray)jSONObject, string));
        }
    }

    public static class TwoPhasedMoneyTransferBuilder
    extends APICall.Builder {
        public TwoPhasedMoneyTransferBuilder() {
            super("sendMoney");
            int n = Nxt.getBlockchain().getHeight();
            this.secretPhrase(BlockchainTest.ALICE.getSecretPhrase());
            this.feeNQT(2L * ChildChain.IGNIS.ONE_COIN);
            this.recipient(BlockchainTest.BOB.getId());
            this.param("amountNQT", 50L * ChildChain.IGNIS.ONE_COIN);
            this.param("phased", "true");
            this.param("phasingVotingModel", VoteWeighting.VotingModel.ACCOUNT.getCode());
            this.param("phasingQuorum", 1);
            this.param("phasingWhitelisted", BlockchainTest.CHUCK.getStrId());
            this.param("phasingFinishHeight", n + 50);
        }

        public TwoPhasedMoneyTransferBuilder fee(long l) {
            this.feeNQT(l);
            return this;
        }

        public TwoPhasedMoneyTransferBuilder votingModel(byte by) {
            this.param("phasingVotingModel", by);
            return this;
        }

        public TwoPhasedMoneyTransferBuilder finishHeight(int n) {
            this.param("phasingFinishHeight", n);
            return this;
        }

        public TwoPhasedMoneyTransferBuilder minBalance(long l, byte by) {
            this.param("phasingMinBalance", l);
            this.param("phasingMinBalanceModel", by);
            return this;
        }

        public TwoPhasedMoneyTransferBuilder quorum(int n) {
            this.param("phasingQuorum", n);
            return this;
        }

        public TwoPhasedMoneyTransferBuilder noWhitelist() {
            this.param("phasingWhitelisted", "");
            return this;
        }

        public TwoPhasedMoneyTransferBuilder whitelisted(long l) {
            this.param("phasingWhitelisted", Long.toUnsignedString(l));
            return this;
        }

        public TwoPhasedMoneyTransferBuilder holding(long l) {
            this.param("phasingHolding", Long.toUnsignedString(l));
            return this;
        }
    }
}

