/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import nxt.BlockchainTest;
import nxt.http.APICall;
import nxt.http.twophased.TestCreateTwoPhased;
import nxt.http.twophased.TwoPhasedSuite;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestGetAccountPhasedTransactions
extends BlockchainTest {
    static APICall phasedTransactionsApiCall(long l) {
        return new APICall.Builder("getAccountPhasedTransactions").param("account", Long.toUnsignedString(l)).param("firstIndex", 0).param("lastIndex", 10).build();
    }

    static APICall phasedTransactionsApiCall() {
        return TestGetAccountPhasedTransactions.phasedTransactionsApiCall(ALICE.getId());
    }

    @Test
    public void simpleOutgoingLookup() {
        APICall aPICall = new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().build();
        JSONObject jSONObject = TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        TestGetAccountPhasedTransactions.generateBlock();
        JSONObject jSONObject2 = TestGetAccountPhasedTransactions.phasedTransactionsApiCall().invoke();
        Logger.logMessage((String)("getAccountPhasedTransactionsResponse:" + jSONObject2.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"transactions");
        Assert.assertTrue((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, (String)jSONObject.get((Object)"fullHash")));
        jSONObject2 = TestGetAccountPhasedTransactions.phasedTransactionsApiCall(CHUCK.getId()).invoke();
        Logger.logMessage((String)("getAccountPhasedTransactionsResponse:" + jSONObject2.toJSONString()));
        jSONArray = (JSONArray)jSONObject2.get((Object)"transactions");
        Assert.assertFalse((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, (String)jSONObject.get((Object)"fullHash")));
    }

    @Test
    public void simpleIngoingLookup() {
        APICall aPICall = new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().build();
        JSONObject jSONObject = TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        TestGetAccountPhasedTransactions.generateBlock();
        JSONObject jSONObject2 = TestGetAccountPhasedTransactions.phasedTransactionsApiCall(BOB.getId()).invoke();
        Logger.logMessage((String)("getAccountPhasedTransactionsResponse:" + jSONObject2.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"transactions");
        Assert.assertTrue((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, (String)jSONObject.get((Object)"fullHash")));
        jSONObject2 = TestGetAccountPhasedTransactions.phasedTransactionsApiCall(CHUCK.getId()).invoke();
        Logger.logMessage((String)("getAccountPhasedTransactionsResponse:" + jSONObject2.toJSONString()));
        jSONArray = (JSONArray)jSONObject2.get((Object)"transactions");
        Assert.assertFalse((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, (String)jSONObject.get((Object)"fullHash")));
    }

    @Test
    public void multiple() {
        JSONObject jSONObject = TestGetAccountPhasedTransactions.phasedTransactionsApiCall().invoke();
        Logger.logMessage((String)("getAccountPhasedTransactionsResponse:" + jSONObject.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject.get((Object)"transactions");
        int n = jSONArray.size();
        APICall aPICall = new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().build();
        JSONObject jSONObject2 = TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        JSONObject jSONObject3 = TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        TestGetAccountPhasedTransactions.generateBlock();
        jSONObject = TestGetAccountPhasedTransactions.phasedTransactionsApiCall().invoke();
        Logger.logMessage((String)("getAccountPhasedTransactionsResponse:" + jSONObject.toJSONString()));
        jSONArray = (JSONArray)jSONObject.get((Object)"transactions");
        int n2 = jSONArray.size();
        Assert.assertTrue((n2 - n == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, (String)jSONObject2.get((Object)"fullHash")));
        Assert.assertTrue((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, (String)jSONObject3.get((Object)"fullHash")));
    }

    @Test
    public void sorting() {
        APICall aPICall;
        for (int i = 0; i < 15; ++i) {
            aPICall = new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().build();
            TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        }
        JSONObject jSONObject = TestGetAccountPhasedTransactions.phasedTransactionsApiCall().invoke();
        Logger.logMessage((String)("getAccountPhasedTransactionsResponse:" + jSONObject.toJSONString()));
        aPICall = (JSONArray)jSONObject.get((Object)"transactions");
        int n = Integer.MAX_VALUE;
        for (Object e : aPICall) {
            JSONObject jSONObject2 = (JSONObject)e;
            int n2 = ((Long)jSONObject2.get((Object)"height")).intValue();
            Assert.assertTrue((n2 <= n ? 1 : 0) != 0);
            n = n2;
        }
    }
}

