/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.account.PaymentFxtTransactionType;
import nxt.account.PaymentTransactionType;
import nxt.blockchain.ChildChain;
import nxt.blockchain.FxtChain;
import nxt.blockchain.FxtTransactionType;
import nxt.blockchain.TransactionType;
import nxt.http.APICall;
import nxt.http.accountControl.ACTestUtils;
import nxt.util.JSONAssert;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestGetExecutedTransactions
extends BlockchainTest {
    @Test
    public void testExecutedAtHeight() {
        long l = ChildChain.IGNIS.ONE_COIN * 3L;
        TreeSet<String> treeSet = new TreeSet<String>();
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = Nxt.getBlockchain().getHeight() + 10;
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", l);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK).quorum(1);
        for (int i = 0; i < 20; ++i) {
            int n2 = Nxt.getBlockchain().getHeight();
            int n4 = n2 + 10;
            phasingBuilder.param("phasingFinishHeight", n4).param("amountNQT", l + (long)i);
            String string2 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
            if (n2 < n - 2 && n < n4) {
                treeSet.add(string2);
                arrayList.add(ChildChain.IGNIS.getId() + ":" + string2);
            }
            APICall.Builder builder = new APICall.Builder("sendMoney").secretPhrase(ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).feeNQT(ChildChain.IGNIS.ONE_COIN);
            IntStream.range(0, 10).forEach(n3 -> {
                builder.param("amountNQT", l + (long)n3);
                String string = new JSONAssert(builder.build().invoke()).str("fullHash");
                if (n2 + 1 == n) {
                    treeSet.add(string);
                }
            });
            if (n2 + 1 == n) {
                APICall.Builder builder2 = ACTestUtils.approveBuilder(arrayList.get(0), CHUCK, null);
                builder2.param("phasedTransaction", arrayList.toArray(new String[arrayList.size()]));
                string = new JSONAssert(builder2.build().invoke()).str("fullHash");
            }
            TestGetExecutedTransactions.generateBlock();
        }
        SortedSet<String> sortedSet = this.getExecutedTransactionsIds(n, BOB, PaymentTransactionType.ORDINARY);
        Assert.assertEquals(treeSet, sortedSet);
        sortedSet = this.getExecutedTransactionsIds(n, null, PaymentTransactionType.ORDINARY);
        Assert.assertEquals(treeSet, sortedSet);
        sortedSet = this.getExecutedTransactionsIds(n, null, null);
        TreeSet<String> treeSet2 = new TreeSet<String>((Collection<String>)treeSet);
        treeSet2.add(string);
        Assert.assertEquals(treeSet2, sortedSet);
        APICall.Builder builder = this.executedTransactionsBuilder(BOB, null);
        builder.param("height", n);
        builder.param("type", PaymentTransactionType.ORDINARY.getType());
        sortedSet = this.getTransactionIds(new JSONAssert(builder.build().invoke()));
        Assert.assertEquals(treeSet, sortedSet);
    }

    @Test
    public void testConfirmed() {
        long l = ChildChain.IGNIS.ONE_COIN * 3L;
        TreeSet<String> treeSet = new TreeSet<String>();
        APICall.Builder builder = this.executedTransactionsBuilder(BOB, PaymentTransactionType.ORDINARY);
        builder.param("numberOfConfirmations", 0);
        treeSet.addAll(this.getTransactionIds(new JSONAssert(builder.build().invoke())));
        int n = 5;
        int n3 = Nxt.getBlockchain().getHeight() + 20 - n;
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
        phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", l);
        phasingBuilder.votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK).quorum(1);
        IntStream.range(0, 20).forEach(n2 -> {
            int n4 = Nxt.getBlockchain().getHeight();
            int n5 = n4 + 10;
            phasingBuilder.param("phasingFinishHeight", n5).param("amountNQT", l + (long)n2);
            String string = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
            APICall.Builder builder = new APICall.Builder("sendMoney").secretPhrase(ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).feeNQT(ChildChain.IGNIS.ONE_COIN);
            IntStream.range(0, 10).forEach(n3 -> {
                builder.param("amountNQT", l + (long)n3);
                String string = new JSONAssert(builder.build().invoke()).str("fullHash");
                if (n4 + 1 <= n3) {
                    treeSet.add(string);
                }
            });
            TestGetExecutedTransactions.generateBlock();
            if (n4 + 2 <= n3) {
                treeSet.add(string);
            }
            ACTestUtils.approve(string, CHUCK, null);
        });
        builder = this.executedTransactionsBuilder(BOB, PaymentTransactionType.ORDINARY);
        builder.param("numberOfConfirmations", n);
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        Assert.assertEquals(treeSet, this.getTransactionIds(jSONAssert));
        builder = this.executedTransactionsBuilder(null, PaymentTransactionType.ORDINARY);
        builder.param("numberOfConfirmations", n);
        jSONAssert = new JSONAssert(builder.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").startsWith("At least one of"));
    }

    @Test
    public void testOrder() {
        long l = ChildChain.IGNIS.ONE_COIN * 3L;
        ArrayList arrayList = new ArrayList();
        LinkedList linkedList = new LinkedList();
        IntStream.range(0, 10).forEach(n -> {
            int n2 = Nxt.getBlockchain().getHeight();
            int n3 = n2 + 50;
            ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE);
            phasingBuilder.param("recipient", BOB.getStrId()).param("amountNQT", l);
            phasingBuilder.votingModel(VoteWeighting.VotingModel.ACCOUNT).whitelist(CHUCK).quorum(1);
            phasingBuilder.param("phasingFinishHeight", n3).param("amountNQT", l + (long)n);
            String string = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
            arrayList.add(string);
        });
        TestGetExecutedTransactions.generateBlock();
        IntStream.range(0, 10).forEach(n -> {
            APICall.Builder builder = new APICall.Builder("sendMoney").secretPhrase(ALICE.getSecretPhrase()).param("recipient", BOB.getStrId()).feeNQT(ChildChain.IGNIS.ONE_COIN);
            builder.param("amountNQT", l + (long)n);
            String string = new JSONAssert(builder.build().invoke()).str("fullHash");
            linkedList.addFirst(string);
            TestGetExecutedTransactions.generateBlock();
            String string2 = (String)arrayList.get(n);
            ACTestUtils.approve(string2, CHUCK, null);
            linkedList.addFirst(string2);
            TestGetExecutedTransactions.generateBlock();
        });
        APICall.Builder builder = this.executedTransactionsBuilder(BOB, PaymentTransactionType.ORDINARY);
        builder.param("lastIndex", 19);
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        Assert.assertEquals(linkedList, this.getOrderedTransactionIds(jSONAssert));
    }

    @Test
    public void testFXT() {
        long l = FxtChain.FXT.ONE_COIN * 3L;
        int n = Nxt.getBlockchain().getHeight() + 3;
        ArrayList arrayList = new ArrayList();
        IntStream.range(0, 9).forEach(n2 -> {
            int n4 = Nxt.getBlockchain().getHeight();
            APICall.Builder builder = new APICall.Builder("sendMoney").secretPhrase(ALICE.getSecretPhrase()).param("chain", FxtChain.FXT.getId()).param("recipient", BOB.getStrId()).feeNQT(FxtChain.FXT.ONE_COIN * 10L);
            IntStream.range(0, Math.min(15, 10)).forEach(n3 -> {
                long l2 = System.currentTimeMillis();
                builder.param("amountNQT", l + (long)n3);
                String string = new JSONAssert(builder.build().invoke()).str("fullHash");
                if (n4 + 1 == n) {
                    arrayList.add(string);
                }
                while (System.currentTimeMillis() == l2) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            });
            TestGetExecutedTransactions.generateBlock();
        });
        SortedSet<String> sortedSet = this.getExecutedTransactionsIds(n, BOB, PaymentFxtTransactionType.ORDINARY);
        Assert.assertEquals(new TreeSet(arrayList), sortedSet);
        APICall.Builder builder = this.executedTransactionsBuilder(BOB, PaymentFxtTransactionType.ORDINARY);
        builder.param("height", n);
        int n3 = 3;
        int n4 = 4;
        builder.param("firstIndex", n3);
        builder.param("lastIndex", arrayList.size() - n4);
        sortedSet = this.getTransactionIds(new JSONAssert(builder.build().invoke()));
        List list = arrayList.subList(0, arrayList.size() - n3);
        list = list.subList(n4 - 1, list.size());
        Assert.assertEquals(new TreeSet(list), sortedSet);
    }

    private SortedSet<String> getExecutedTransactionsIds(int n, Tester tester, TransactionType transactionType) {
        APICall.Builder builder = this.executedTransactionsBuilder(tester, transactionType);
        builder.param("height", n);
        JSONAssert jSONAssert = new JSONAssert(builder.build().invoke());
        return this.getTransactionIds(jSONAssert);
    }

    private SortedSet<String> getTransactionIds(JSONAssert jSONAssert) {
        return jSONAssert.array("transactions", JSONObject.class).stream().map(jSONObject -> new JSONAssert((JSONObject)jSONObject).str("fullHash")).collect(Collectors.toCollection(TreeSet::new));
    }

    private List<String> getOrderedTransactionIds(JSONAssert jSONAssert) {
        return jSONAssert.array("transactions", JSONObject.class).stream().map(jSONObject -> new JSONAssert((JSONObject)jSONObject).str("fullHash")).collect(Collectors.toCollection(ArrayList::new));
    }

    private APICall.Builder executedTransactionsBuilder(Tester tester, TransactionType transactionType) {
        APICall.Builder builder = new APICall.Builder("getExecutedTransactions");
        if (transactionType != null) {
            builder.param("type", transactionType.getType()).param("subtype", transactionType.getSubtype());
        }
        if (tester != null) {
            builder.param("recipient", tester.getStrId());
        }
        if (transactionType instanceof FxtTransactionType) {
            builder.param("chain", FxtChain.FXT.getId());
        }
        return builder;
    }
}

