/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import nxt.BlockchainTest;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.twophased.TestCreateTwoPhased;
import nxt.http.twophased.TwoPhasedSuite;
import nxt.util.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestGetVoterPhasedTransactions
extends BlockchainTest {
    static APICall getVoterPhasedTransactions() {
        return new APICall.Builder("getVoterPhasedTransactions").param("account", Long.toUnsignedString(CHUCK.getId())).param("firstIndex", 0).param("lastIndex", 10).build();
    }

    @Test
    public void simpleTransactionLookup() {
        APICall aPICall = new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().build();
        JSONObject jSONObject = TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestGetVoterPhasedTransactions.generateBlock();
        JSONObject jSONObject2 = TestGetVoterPhasedTransactions.getVoterPhasedTransactions().invoke();
        Logger.logMessage((String)("getVoterPhasedTransactionsResponse:" + jSONObject2.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"transactions");
        Assert.assertTrue((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, string));
    }

    @Test
    public void transactionLookupAfterVote() {
        APICall aPICall = new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().build();
        JSONObject jSONObject = TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        String string = (String)jSONObject.get((Object)"fullHash");
        TestGetVoterPhasedTransactions.generateBlock();
        long l = ChildChain.IGNIS.ONE_COIN;
        aPICall = new APICall.Builder("approveTransaction").param("secretPhrase", CHUCK.getSecretPhrase()).param("phasedTransaction", ChildChain.IGNIS.getId() + ":" + string).param("feeNQT", l).build();
        JSONObject jSONObject2 = aPICall.invoke();
        Logger.logMessage((String)("approvePhasedTransactionResponse:" + jSONObject2.toJSONString()));
        TestGetVoterPhasedTransactions.generateBlock();
        jSONObject2 = TestGetVoterPhasedTransactions.getVoterPhasedTransactions().invoke();
        Logger.logMessage((String)("getVoterPhasedTransactionsResponse:" + jSONObject2.toJSONString()));
        JSONArray jSONArray = (JSONArray)jSONObject2.get((Object)"transactions");
        Assert.assertFalse((boolean)TwoPhasedSuite.searchForTransactionId(jSONArray, string));
    }

    @Test
    public void sorting() {
        APICall aPICall;
        for (int i = 0; i < 15; ++i) {
            aPICall = new TestCreateTwoPhased.TwoPhasedMoneyTransferBuilder().build();
            TestCreateTwoPhased.issueCreateTwoPhased(aPICall, false);
        }
        JSONObject jSONObject = TestGetVoterPhasedTransactions.getVoterPhasedTransactions().invoke();
        Logger.logMessage((String)("getVoterPhasedTransactionsResponse:" + jSONObject.toJSONString()));
        aPICall = (JSONArray)jSONObject.get((Object)"transactions");
        int n = Integer.MAX_VALUE;
        for (Object e : aPICall) {
            JSONObject jSONObject2 = (JSONObject)e;
            int n2 = ((Long)jSONObject2.get((Object)"height")).intValue();
            Assert.assertTrue((n2 <= n ? 1 : 0) != 0);
            n = n2;
        }
    }
}

