/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.http.accountControl.ACTestUtils;
import nxt.util.JSONAssert;
import nxt.voting.VoteWeighting;
import org.junit.Assert;
import org.junit.Test;

public class TestPropertyVoting
extends BlockchainTest {
    @Test
    public void testFinishAtCreation() {
        String string = "prop1";
        String string2 = "prop_val";
        APICall.Builder builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, string2);
        builder.build().invoke();
        TestPropertyVoting.generateBlock();
        builder = TestPropertyVoting.createGenericBuilder();
        builder.param("phasingSenderPropertySetter", CHUCK.getStrId());
        builder.param("phasingSenderPropertyName", string);
        builder.param("phasingSenderPropertyValue", string2);
        builder.build().invoke();
        TestPropertyVoting.generateBlock();
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testApproveAfterCreation() {
        String string = "prop2";
        String string2 = "prop_val";
        ACTestUtils.PhasingBuilder phasingBuilder = TestPropertyVoting.createGenericBuilder();
        phasingBuilder.param("phasingSenderPropertySetter", CHUCK.getStrId());
        phasingBuilder.param("phasingSenderPropertyName", string);
        phasingBuilder.param("phasingSenderPropertyValue", string2);
        phasingBuilder.build().invoke();
        TestPropertyVoting.generateBlock();
        phasingBuilder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, string2);
        phasingBuilder.build().invoke();
        TestPropertyVoting.generateBlock();
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        TestPropertyVoting.generateBlocks(5);
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testRevokeApproval() {
        String string = "prop2";
        String string2 = "prop_val";
        ACTestUtils.PhasingBuilder phasingBuilder = TestPropertyVoting.createGenericBuilder();
        phasingBuilder.param("phasingSenderPropertySetter", CHUCK.getStrId());
        phasingBuilder.param("phasingSenderPropertyName", string);
        phasingBuilder.param("phasingSenderPropertyValue", string2);
        String string3 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestPropertyVoting.generateBlock();
        phasingBuilder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, string2);
        phasingBuilder.build().invoke();
        TestPropertyVoting.generateBlock();
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.PENDING), (Object)((Object)ACTestUtils.getPhasingStatus(string3)));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        phasingBuilder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, "");
        phasingBuilder.build().invoke();
        TestPropertyVoting.generateBlock();
        TestPropertyVoting.generateBlocks(5);
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.REJECTED), (Object)((Object)ACTestUtils.getPhasingStatus(string3)));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testRecipientProperty() {
        String string = "prop1";
        String string2 = "prop_val";
        APICall.Builder builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, string2);
        builder.build().invoke();
        TestPropertyVoting.generateBlock();
        ACTestUtils.PhasingBuilder phasingBuilder = TestPropertyVoting.createGenericBuilder();
        phasingBuilder.param("phasingRecipientPropertySetter", CHUCK.getStrId());
        phasingBuilder.param("phasingRecipientPropertyName", string);
        phasingBuilder.param("phasingRecipientPropertyValue", string2);
        String string3 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestPropertyVoting.generateBlocks(7);
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.REJECTED), (Object)((Object)ACTestUtils.getPhasingStatus(string3)));
        Assert.assertEquals((long)0L, (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, BOB, string, string2);
        builder.build().invoke();
        TestPropertyVoting.generateBlock();
        phasingBuilder.param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + 7);
        string3 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestPropertyVoting.generateBlock();
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.APPROVED), (Object)((Object)ACTestUtils.getPhasingStatus(string3)));
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
        string = "prop2";
        String string4 = "AliceName";
        phasingBuilder = new ACTestUtils.PhasingBuilder("setAccountInfo", ALICE).votingModel(VoteWeighting.VotingModel.PROPERTY).quorum(1);
        phasingBuilder.feeNQT(3L * ChildChain.IGNIS.ONE_COIN).param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + 7);
        phasingBuilder.param("name", string4);
        phasingBuilder.param("phasingRecipientPropertySetter", CHUCK.getStrId());
        phasingBuilder.param("phasingRecipientPropertyName", string);
        phasingBuilder.param("phasingRecipientPropertyValue", string2);
        new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestPropertyVoting.generateBlock();
        JSONAssert jSONAssert = new JSONAssert(new APICall.Builder("getAccount").param("account", ALICE.getStrId()).build().invoke());
        Assert.assertEquals((Object)string4, (Object)jSONAssert.str("name"));
    }

    @Test
    public void testEmptyPropertyValue() {
        String string = "prop1";
        APICall.Builder builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string, "doesn't matter");
        builder.build().invoke();
        TestPropertyVoting.generateBlock();
        ACTestUtils.PhasingBuilder phasingBuilder = TestPropertyVoting.createGenericBuilder();
        phasingBuilder.property("Sender", CHUCK, string, "");
        String string2 = new JSONAssert(phasingBuilder.build().invoke()).str("fullHash");
        TestPropertyVoting.generateBlock();
        Assert.assertEquals((Object)((Object)ACTestUtils.PhasingStatus.APPROVED), (Object)((Object)ACTestUtils.getPhasingStatus(string2)));
        Assert.assertEquals((long)(100L * ChildChain.IGNIS.ONE_COIN), (long)BOB.getChainBalanceDiff(ChildChain.IGNIS.getId()));
    }

    @Test
    public void testPropertyValueLength() {
        String string = "\u20ac";
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 42; ++i) {
            stringBuilder.append(string);
        }
        String string2 = "prop1";
        String string3 = stringBuilder.toString();
        APICall.Builder builder = TestPropertyVoting.createSetPropertyBuilder(CHUCK, ALICE, string2, string3);
        builder.build().invoke();
        TestPropertyVoting.generateBlock();
        ACTestUtils.PhasingBuilder phasingBuilder = TestPropertyVoting.createGenericBuilder();
        phasingBuilder.property("Sender", CHUCK, string2, string3 + string);
        JSONAssert jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        Assert.assertTrue((boolean)jSONAssert.str("errorDescription").contains("Invalid SenderPropertyValue"));
        phasingBuilder.property("Sender", CHUCK, string2, string3);
        jSONAssert = new JSONAssert(phasingBuilder.build().invoke());
        jSONAssert.fullHash();
    }

    public static APICall.Builder createSetPropertyBuilder(Tester tester, Tester tester2, String string, String string2) {
        return new APICall.Builder("setAccountProperty").param("secretPhrase", tester.getSecretPhrase()).param("recipient", tester2.getStrId()).param("feeNQT", 3L * ChildChain.IGNIS.ONE_COIN).param("property", string).param("value", string2);
    }

    public static ACTestUtils.PhasingBuilder createGenericBuilder() {
        ACTestUtils.PhasingBuilder phasingBuilder = new ACTestUtils.PhasingBuilder("sendMoney", ALICE).votingModel(VoteWeighting.VotingModel.PROPERTY).quorum(1);
        phasingBuilder.feeNQT(3L * ChildChain.IGNIS.ONE_COIN).param("recipient", BOB.getStrId()).param("amountNQT", 100L * ChildChain.IGNIS.ONE_COIN).param("phasingFinishHeight", Nxt.getBlockchain().getHeight() + 7);
        return phasingBuilder;
    }
}

