/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.twophased;

import nxt.BlockchainTest;
import nxt.Tester;
import nxt.account.Account;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.util.Convert;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestTrustlessAssetSwap
extends BlockchainTest {
    @Test
    public void assetSwap() {
        JSONObject jSONObject = new APICall.Builder("issueAsset").param("secretPhrase", ALICE.getSecretPhrase()).param("name", "AliceAsset").param("description", "AliceAssetDescription").param("quantityQNT", 1000).param("decimals", 0).param("feeNQT", 1000L * ChildChain.IGNIS.ONE_COIN).build().invoke();
        TestTrustlessAssetSwap.generateBlock();
        JSONObject jSONObject2 = new APICall.Builder("issueAsset").param("secretPhrase", BOB.getSecretPhrase()).param("name", "BobAsset").param("description", "BobAssetDescription").param("quantityQNT", 1000).param("decimals", 0).param("feeNQT", 2000L * ChildChain.IGNIS.ONE_COIN).build().invoke();
        TestTrustlessAssetSwap.generateBlock();
        String string = Tester.responseToStringId(jSONObject);
        JSONObject jSONObject3 = new APICall.Builder("transferAsset").param("publicKey", ALICE.getPublicKeyStr()).param("recipient", BOB.getStrId()).param("asset", string).param("quantityQNT", 100).param("feeNQT", ChildChain.IGNIS.ONE_COIN).build().invoke();
        JSONObject jSONObject4 = new APICall.Builder("signTransaction").param("secretPhrase", ALICE.getSecretPhrase()).param("unsignedTransactionBytes", (String)jSONObject3.get((Object)"unsignedTransactionBytes")).build().invoke();
        String string2 = (String)jSONObject4.get((Object)"fullHash");
        Assert.assertEquals((long)64L, (long)string2.length());
        String string3 = (String)jSONObject4.get((Object)"transactionBytes");
        String string4 = Tester.responseToStringId(jSONObject2);
        JSONObject jSONObject5 = new APICall.Builder("transferAsset").param("secretPhrase", BOB.getSecretPhrase()).param("recipient", ALICE.getStrId()).param("asset", string4).param("quantityQNT", 200).param("feeNQT", 3L * ChildChain.IGNIS.ONE_COIN).param("phased", "true").param("phasingFinishHeight", 6).param("phasingVotingModel", 4).param("phasingLinkedTransaction", ChildChain.IGNIS.getId() + ":" + string2).param("phasingQuorum", 1).build().invoke();
        TestTrustlessAssetSwap.generateBlock();
        JSONObject jSONObject6 = new APICall.Builder("getTransaction").param("fullHash", (String)jSONObject5.get((Object)"fullHash")).build().invoke();
        Assert.assertEquals((Object)jSONObject5.get((Object)"fullHash"), (Object)jSONObject6.get((Object)"fullHash"));
        new APICall.Builder("broadcastTransaction").param("transactionBytes", string3).build().invoke();
        TestTrustlessAssetSwap.generateBlock();
        Assert.assertEquals((long)200L, (long)Account.getAssetBalanceQNT((long)ALICE.getId(), (long)Convert.parseUnsignedLong((String)string4)));
        Assert.assertEquals((long)100L, (long)Account.getAssetBalanceQNT((long)BOB.getId(), (long)Convert.parseUnsignedLong((String)string)));
    }
}

