/*
 * Decompiled with CFR 0.152.
 */
package nxt.http.votingsystem;

import nxt.BlockchainTest;
import nxt.Nxt;
import nxt.blockchain.ChildChain;
import nxt.http.APICall;
import nxt.util.Convert;
import nxt.util.Logger;
import nxt.voting.VoteWeighting;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class TestCreatePoll
extends BlockchainTest {
    static String issueCreatePoll(APICall aPICall, boolean bl) {
        JSONObject jSONObject = aPICall.invoke();
        Logger.logMessage((String)("createPollResponse: " + jSONObject.toJSONString()));
        if (!bl) {
            Assert.assertNull((Object)jSONObject.get((Object)"errorCode"));
        }
        TestCreatePoll.generateBlock();
        try {
            byte[] byArray = Convert.parseHexString((String)((String)jSONObject.get((Object)"fullHash")));
            if (!bl && byArray == null) {
                Assert.fail();
            }
            String string = Long.toUnsignedString(Convert.fullHashToId((byte[])byArray));
            aPICall = new APICall.Builder("getPoll").param("poll", string).build();
            JSONObject jSONObject2 = aPICall.invoke();
            Logger.logMessage((String)("getPollResponse:" + jSONObject2.toJSONString()));
            Assert.assertEquals((Object)string, (Object)jSONObject2.get((Object)"poll"));
            return string;
        }
        catch (Throwable throwable) {
            if (!bl) {
                Assert.fail((String)throwable.getMessage());
            }
            return null;
        }
    }

    @Test
    public void createValidPoll() {
        APICall aPICall = new CreatePollBuilder().build();
        TestCreatePoll.issueCreatePoll(aPICall, false);
        TestCreatePoll.generateBlock();
        aPICall = new CreatePollBuilder().votingModel(VoteWeighting.VotingModel.COIN.getCode()).build();
        TestCreatePoll.issueCreatePoll(aPICall, false);
        TestCreatePoll.generateBlock();
    }

    @Test
    public void createInvalidPoll() {
        APICall aPICall = new CreatePollBuilder().minBalance(-ChildChain.IGNIS.ONE_COIN).build();
        TestCreatePoll.issueCreatePoll(aPICall, true);
        TestCreatePoll.generateBlock();
        aPICall = new CreatePollBuilder().minBalance(0L).build();
        TestCreatePoll.issueCreatePoll(aPICall, true);
        TestCreatePoll.generateBlock();
    }

    public static class CreatePollBuilder
    extends APICall.Builder {
        public CreatePollBuilder() {
            super("createPoll");
            this.secretPhrase(BlockchainTest.ALICE.getSecretPhrase());
            this.feeNQT(10L * ChildChain.IGNIS.ONE_COIN);
            this.param("name", "Test1");
            this.param("description", "The most cool Beatles guy?");
            this.param("finishHeight", Nxt.getBlockchain().getHeight() + 100);
            this.param("votingModel", VoteWeighting.VotingModel.ACCOUNT.getCode());
            this.param("minNumberOfOptions", 1);
            this.param("maxNumberOfOptions", 2);
            this.param("minRangeValue", 0);
            this.param("maxRangeValue", 1);
            this.param("minBalance", 10L * ChildChain.IGNIS.ONE_COIN);
            this.param("minBalanceModel", VoteWeighting.MinBalanceModel.COIN.getCode());
            this.param("option00", "Ringo");
            this.param("option01", "Paul");
            this.param("option02", "John");
        }

        public CreatePollBuilder votingModel(byte by) {
            this.param("votingModel", by);
            return this;
        }

        public CreatePollBuilder minBalance(long l) {
            this.param("minBalance", l);
            return this;
        }

        public CreatePollBuilder minBalance(long l, byte by) {
            this.param("minBalance", l);
            this.param("minBalanceModel", by);
            return this;
        }

        public CreatePollBuilder minBalance(long l, byte by, long l2) {
            this.param("minBalance", l);
            this.param("minBalanceModel", by);
            this.param("holdingId", l2);
            return this;
        }
    }
}

