/*
 * Decompiled with CFR 0.152.
 */
package nxt.ms;

import nxt.BlockchainTest;
import nxt.Tester;
import nxt.blockchain.ChildChain;
import nxt.db.TransactionalDb;
import nxt.http.APICall;
import nxt.http.client.PublishExchangeOfferBuilder;
import nxt.http.client.SetAccountPropertyBuilder;
import nxt.http.monetarysystem.TestCurrencyIssuance;
import nxt.ms.Currency;
import nxt.ms.CurrencyFreezeMonitor;
import nxt.util.JSONAssert;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;
import org.junit.Test;

public class CurrencyFreezeMonitorTest
extends BlockchainTest {
    @Test
    public void testOnBlockFreezeCurrency() {
        Currency currency = this.createCurrencyWithOffers();
        CurrencyFreezeMonitorTest.setCurrencyFreezeHeight(currency, this.getHeight() + 1);
        CurrencyFreezeMonitorTest.generateBlock();
        this.assertFrozen(currency);
    }

    @Test
    public void testOnBlockFreezeCurrencyOnFreezeAlias() {
        Currency currency = this.createCurrencyWithOffers();
        CurrencyFreezeMonitorTest.setCurrencyFreezeHeight(currency, 0);
        this.setCurrencyFreezeAccountProperty(currency, this.getHeight() + 2);
        CurrencyFreezeMonitorTest.generateBlock();
        CurrencyFreezeMonitorTest.generateBlock();
        this.assertFrozen(currency);
    }

    private void setCurrencyFreezeAccountProperty(Currency currency, int n) {
        String string = "Freeze" + Long.toUnsignedString(currency.getId());
        String string2 = Integer.toString(n);
        ChildChain childChain = ChildChain.IGNIS;
        new SetAccountPropertyBuilder(ALICE, string, string2).setFeeNQT(childChain.ONE_COIN).invokeNoError();
    }

    private void assertFrozen(Currency currency) {
        this.assertNoOffers(currency);
        this.assertTransactionsFail(currency);
    }

    private void assertTransactionsFail(Currency currency) {
        APICall.InvocationError invocationError = CurrencyFreezeMonitorTest.createTransferCurrencyCall(BOB, currency).invokeWithError();
        Assert.assertEquals((Object)("Currency " + Long.toUnsignedString(currency.getId()) + " is frozen, no transaction is possible."), (Object)invocationError.getErrorDescription());
    }

    private static APICall createTransferCurrencyCall(Tester tester, Currency currency) {
        return new APICall.Builder("transferCurrency").param("secretPhrase", TestCurrencyIssuance.Builder.creator.getSecretPhrase()).param("currency", Long.toUnsignedString(currency.getId())).param("recipient", tester.getStrId()).param("unitsQNT", 3).feeNQT(ChildChain.IGNIS.ONE_COIN).build();
    }

    private void assertNoOffers(Currency currency) {
        Assert.assertEquals((Object)new JSONArray(), (Object)this.getGetSellOffers(currency).get((Object)"offers"));
        Assert.assertEquals((Object)new JSONArray(), (Object)this.getGetBuyOffers(currency).get((Object)"offers"));
    }

    private JSONObject getGetBuyOffers(Currency currency) {
        return this.getOffers("getBuyOffers", currency);
    }

    private JSONObject getGetSellOffers(Currency currency) {
        return this.getOffers("getSellOffers", currency);
    }

    private JSONObject getOffers(String string, Currency currency) {
        return new APICall.Builder(string).param("currency", Long.toUnsignedString(currency.getId())).build().invokeNoError();
    }

    public static void setCurrencyFreezeHeight(Currency currency, int n) {
        TransactionalDb.runInDbTransaction(() -> CurrencyFreezeMonitor.enableFreeze((long)currency.getId(), (int)1, (int)n));
    }

    private Currency createCurrencyWithOffers() {
        Currency currency = CurrencyFreezeMonitorTest.createCurrency();
        this.createOffers(currency);
        return currency;
    }

    private void createOffers(Currency currency) {
        CurrencyFreezeMonitorTest.createTransferCurrencyCall(BOB, currency).invokeNoError();
        CurrencyFreezeMonitorTest.generateBlock();
        new PublishExchangeOfferBuilder(BOB, currency).setInitialBuySupply(1L).setTotalBuyLimit(1L).setInitialSellSupply(1L).setTotalSellLimit(1L).setExpirationHeight(this.getHeight() + 100).invokeNoError();
        CurrencyFreezeMonitorTest.generateBlock();
    }

    public static Currency createCurrency() {
        JSONObject jSONObject = new TestCurrencyIssuance.Builder().build().invokeNoError();
        String string = Tester.hexFullHashToStringId(new JSONAssert(jSONObject).str("fullHash"));
        CurrencyFreezeMonitorTest.generateBlock();
        return Currency.getCurrency((long)Long.parseUnsignedLong(string));
    }
}

