/*
 * Decompiled with CFR 0.152.
 */
package nxt.tools;

import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nxt.account.Account;
import nxt.crypto.Crypto;
import nxt.tools.PassphraseRecovery;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PassphraseRecoveryTest {
    private static Map<Long, byte[]> publicKeys;

    @BeforeClass
    public static void loadPublicKeys() {
        publicKeys = Stream.of("hope peace happen touch easy pretend worthless talk them indeed wheel state", "rshw9abtpsa2", "eOdBVLMgySFvyiTy8xMuRXDTr45oTzB7L5J", "t9G2ymCmDsQij7VtYinqrbGCOAtDDA3WiNr", "5hiig9BPdYoBzWni0QPaCDno6Wz0Vg8oX9yMcXRjEhmkuQKhvB").map(Crypto::getPublicKey).collect(Collectors.toMap(Account::getId, Function.identity()));
    }

    @Test
    public void searchAnyPassphrase() {
        int[] nArray;
        char[] cArray = "hope peace happen touch easy pretend worthless talk them indeed wheel state".toCharArray();
        Object object = nArray = new int[]{9, 18};
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = object[i];
            cArray[n2.intValue()] = 42;
        }
        object = new PassphraseRecovery.Scanner(publicKeys, nArray, cArray, PassphraseRecovery.getDefaultDictionary());
        PassphraseRecovery.Solution solution = object.scan();
        Assert.assertEquals((Object)"ARDOR-XK4R-7VJU-6EQG-7R335", (Object)solution.getRsAccount());
    }

    @Test
    public void searchAnyPassphraseNotFound() {
        int[] nArray;
        char[] cArray = "some non existing account".toCharArray();
        Object object = nArray = new int[]{2, 7};
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = object[i];
            cArray[n2.intValue()] = 42;
        }
        object = new PassphraseRecovery.Scanner(publicKeys, nArray, cArray, PassphraseRecovery.getDefaultDictionary());
        Assert.assertEquals((Object)PassphraseRecovery.NO_SOLUTION, (Object)object.scan());
    }

    @Test
    public void searchAnyPassphraseEmptyKeys() {
        int[] nArray;
        char[] cArray = "hope peace happen touch easy pretend worthless talk them indeed wheel state".toCharArray();
        Object object = nArray = new int[]{9, 18};
        int n = ((int[])object).length;
        for (int i = 0; i < n; ++i) {
            Integer n2 = object[i];
            cArray[n2.intValue()] = 42;
        }
        object = new PassphraseRecovery.Scanner(Collections.emptyMap(), nArray, cArray, PassphraseRecovery.getDefaultDictionary());
        Assert.assertEquals((Object)PassphraseRecovery.NO_SOLUTION, (Object)object.scan());
    }

    @Test
    public void searchSpecificPassphrase() {
        Integer n;
        int[] nArray;
        char[] cArray = "hope peace happen touch easy pretend worthless talk them indeed wheel state".toCharArray();
        int[] nArray2 = nArray = new int[]{27, 9};
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            n = nArray2[i];
            cArray[n.intValue()] = 42;
        }
        long l = 5873880488492319831L;
        Map<Long, byte[]> map = Collections.singletonMap(l, publicKeys.get(l));
        n = new PassphraseRecovery.Scanner(map, nArray, cArray, PassphraseRecovery.getDefaultDictionary());
        PassphraseRecovery.Solution solution = n.scan();
        Assert.assertEquals((Object)"ARDOR-XK4R-7VJU-6EQG-7R335", (Object)solution.getRsAccount());
    }

    @Test
    public void searchSingleTypo() {
        char[] cArray = "hope peace happen touch easy pretend worthless talk them indeed wheel state".toCharArray();
        cArray[18] = 42;
        PassphraseRecovery.Scanner scanner = new PassphraseRecovery.Scanner(publicKeys, new int[0], cArray, PassphraseRecovery.getDefaultDictionary());
        PassphraseRecovery.Solution solution = scanner.scan();
        Assert.assertEquals((Object)"ARDOR-XK4R-7VJU-6EQG-7R335", (Object)solution.getRsAccount());
    }
}

