/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.util.List;
import nxt.Tester;
import nxt.addons.JO;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.junit.Assert;

public class JSONAssert {
    private final JSONObject obj;

    public JSONAssert(JSONObject jSONObject) {
        this.obj = jSONObject;
    }

    public JSONAssert(JO jO) {
        this(jO.toJSONObject());
    }

    public JSONAssert subObj(String string) {
        Object object = this.obj.get((Object)string);
        Assert.assertNotNull((String)("Missing " + string), (Object)object);
        if (object instanceof JSONObject) {
            return new JSONAssert((JSONObject)object);
        }
        throw new AssertionError((Object)("Type of " + string + " is not object"));
    }

    public String str(String string) {
        Object object = this.obj.get((Object)string);
        Assert.assertNotNull((String)String.format("No key '%s' in object '%s'", string, this.obj), (Object)object);
        if (object instanceof String) {
            return (String)object;
        }
        throw new AssertionError((Object)String.format("Type of '%s' is not String, but '%s' and value is '%s'", string, object.getClass(), object));
    }

    public String fullHash() {
        return this.str("fullHash");
    }

    public String id() {
        return Tester.hexFullHashToStringId(this.fullHash());
    }

    public long integer(String string) {
        Object object = this.obj.get((Object)string);
        Assert.assertNotNull((Object)object);
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new AssertionError((Object)("Type of " + string + " is not int"));
    }

    public <T> List<T> array(String string, Class<T> clazz) {
        Object object = this.obj.get((Object)string);
        Assert.assertNotNull((Object)object);
        if (object instanceof JSONArray) {
            return (List)object;
        }
        throw new AssertionError((Object)("Type of " + string + " is not array"));
    }

    public JSONObject getJson() {
        return this.obj;
    }
}

