/*
 * Decompiled with CFR 0.152.
 */
package nxt.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Test;

public class JsonMessageTest {
    @Test
    public void message() {
        this.validate("{\n  \"type\": \"dividend\",\n  \"contractId\": \"2112610727280991058\",\n  \"height\": 260315,\n  \"total\": \"42700000000\",\n  \"percentage\": \"0%\",\n  \"shares\": 50\n}");
        this.validate("{\\n  \"type\": \"dividend\",\\n  \"contractId\": \"2112610727280991058\",\\n  \"height\": 260315,\\n  \"total\": \"42700000000\",\\n  \"percentage\": \"0%\",\\n  \"shares\": 50\\n}");
        this.validate("{\n  \"type\": \"dividend\",\n  \"contractId\": \"11263051911300205537\",\n  \"height\": 260315,\n  \"total\": \"42700000000\",\n  \"percentage\": \"0.1%\",\n  \"shares\": 1000\n}");
        this.validate("{\n  \"type\": \"dividend\",\n  \"contractId\": \"11263051911300205537\",\n  \"height\": 260315,\n  \"total\": \"42700000000\",\n  \"percentage\": \"0.01%\",\n  \"shares\": 70\n}");
        this.validate("{\n  \"type\": \"dividend\",\n  \"contractId\": \"2112610727280991058\",\n  \"height\": 260315,\n  \"total\": \"42700000000\",\n  \"percentage\": \"0.33%\",\n  \"shares\": 5383\n}");
        this.validate("{\n  \"type\": \"dividend\",\n  \"contractId\": \"11263051911300205537\",\n  \"height\": 260315,\n  \"total\": \"42700000000\",\n  \"percentage\": \"0.1%\",\n  \"shares\": 1000\n}");
        this.validate("{\n  \"type\": \"dividend\",\n  \"contractId\": \"2112610727280991058\",\n  \"height\": 260315,\n  \"total\": \"42700000000\",\n  \"percentage\": \"0.18%\",\n  \"shares\": 3000\n}");
        this.validate("\u05d0\u05d1\u05d2");
        this.validate("\u201c");
    }

    private void validate(String string) {
        JSONObject jSONObject;
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put((Object)"message", (Object)string);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Closeable closeable = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            Object object = null;
            try {
                jSONObject2.writeJSONString((Writer)closeable);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (object != null) {
                        try {
                            ((Writer)closeable).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Writer)closeable).close();
                    }
                }
            }
            closeable = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            object = new BufferedReader(new InputStreamReader((InputStream)closeable, "UTF-8"));
            Throwable throwable = null;
            try {
                jSONObject = (JSONObject)JSONValue.parse((Reader)object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((Reader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((Reader)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        Assert.assertEquals((Object)string, (Object)jSONObject.get((Object)"message"));
    }
}

