/*
 * Decompiled with CFR 0.152.
 */
package com.jelurida.ardor.contracts;

import com.jelurida.ardor.contracts.BittrexRateProvider;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import nxt.account.Account;
import nxt.addons.AbstractContract;
import nxt.addons.AbstractContractContext;
import nxt.addons.BlockContext;
import nxt.addons.ChainWrapper;
import nxt.addons.ContractParametersProvider;
import nxt.addons.ContractSetupParameter;
import nxt.addons.JA;
import nxt.addons.JO;
import nxt.addons.RequestContext;
import nxt.addons.TransactionContext;
import nxt.addons.ValidateChain;
import nxt.addons.ValidateContractRunnerIsRecipient;
import nxt.crypto.EncryptedData;
import nxt.http.APICall;
import nxt.http.callers.GetBlockchainStatusCall;
import nxt.http.callers.GetCoinExchangeTradesCall;
import nxt.http.callers.SendMessageCall;
import nxt.http.callers.SetAccountPropertyCall;
import nxt.http.responses.TransactionResponse;
import nxt.util.Convert;

public class IgnisArdorRates<InvocationData, ReturnedData>
extends AbstractContract<InvocationData, ReturnedData> {
    public JO processBlock(BlockContext context) {
        int frequency = ((Params)context.getParams(Params.class)).frequency();
        if (frequency == 0) {
            return context.generateInfoResponse("frequency cannot be 0", new Object[0]);
        }
        if (context.getHeight() % frequency != 0) {
            return context.generateInfoResponse("height is not divisible by frequency", new Object[0]);
        }
        JO response = this.getTradeData((AbstractContractContext)context);
        SetAccountPropertyCall setAccountPropertyCall = ((SetAccountPropertyCall)SetAccountPropertyCall.create((int)context.getChain("IGNIS").getId()).recipient(context.getAccount())).property("IgnisPerArdorRates").value(response.toJSONString());
        return context.createTransaction((APICall.Builder)setAccountPropertyCall);
    }

    @ValidateContractRunnerIsRecipient
    @ValidateChain(accept={2})
    public JO processTransaction(TransactionContext context) {
        ChainWrapper ignisChain = context.getChain("IGNIS");
        if (context.getAmountNQT() < ignisChain.getOneCoin()) {
            return context.generateErrorResponse(10001, "Oracle requires a payment of 1 IGNIS to operate", new Object[0]);
        }
        JO response = this.getTradeData((AbstractContractContext)context);
        EncryptedData encryptedData = context.getConfig().encryptTo(Account.getPublicKey((long)context.getSenderId()), Convert.toBytes((String)response.toJSONString(), (boolean)true), true);
        SendMessageCall sendMessageCall = (SendMessageCall)((SendMessageCall)((SendMessageCall)((SendMessageCall)SendMessageCall.create((int)context.getChainOfTransaction().getId()).recipient(context.getSenderId())).encryptedMessageData(encryptedData.getData())).encryptedMessageNonce(encryptedData.getNonce())).encryptedMessageIsPrunable(true);
        return context.createTransaction((APICall.Builder)sendMessageCall);
    }

    public JO processRequest(RequestContext context) {
        JO response = this.getTradeData((AbstractContractContext)context);
        return context.generateResponse(response);
    }

    private JO getTradeData(AbstractContractContext context) {
        JO response = new JO();
        JO ignisTickerResponse = BittrexRateProvider.getRate(context, "IGNIS");
        if (ignisTickerResponse.get("errorCode") != null) {
            return response;
        }
        double ignisLastTrade = ignisTickerResponse.getJo("result").getDouble("Last");
        JO ardorTickerResponse = BittrexRateProvider.getRate(context, "ARDR");
        if (ardorTickerResponse.get("errorCode") != null) {
            return response;
        }
        double ardorLastTrade = ardorTickerResponse.getJo("result").getDouble("Last");
        long ignisNQTPerARDR = BigDecimal.valueOf(ardorLastTrade).multiply(BigDecimal.valueOf(context.getChain("IGNIS").getOneCoin())).divide(BigDecimal.valueOf(ignisLastTrade), RoundingMode.HALF_EVEN).longValue();
        response.put("BTRX", (Object)ignisNQTPerARDR);
        JO getCoinExchangeTradesResponse = GetCoinExchangeTradesCall.create((int)2).exchange(1).firstIndex(0).lastIndex(1).call();
        JA trades = getCoinExchangeTradesResponse.getArray("trades");
        if (trades.size() > 0) {
            JO trade = trades.get(0);
            response.put("CE", trade.get("priceNQTPerCoin"));
        }
        return response;
    }

    public <T extends TransactionResponse> boolean isDuplicate(T myTransaction, List<T> existingUnconfirmedTransactions) {
        if (super.isDuplicate(myTransaction, existingUnconfirmedTransactions)) {
            return true;
        }
        for (TransactionResponse transactionResponse : existingUnconfirmedTransactions) {
            if (transactionResponse.getChainId() == myTransaction.getChainId() && transactionResponse.getType() == myTransaction.getType() && transactionResponse.getSubType() == myTransaction.getSubType() && transactionResponse.getSenderId() == myTransaction.getSenderId() && transactionResponse.getRecipientId() == myTransaction.getRecipientId()) continue;
        }
        return false;
    }

    @ContractParametersProvider
    public static interface Params {
        @ContractSetupParameter
        default public int frequency() {
            JO blockchainStatus = GetBlockchainStatusCall.create().call();
            if (blockchainStatus.getBoolean("isTestnet")) {
                return 3;
            }
            return 60;
        }
    }
}

