/*
 * Copyright © 2013-2016 The Nxt Core Developers.
 * Copyright © 2016-2019 Jelurida IP B.V.
 *
 * See the LICENSE.txt file at the top-level directory of this distribution
 * for licensing information.
 *
 * Unless otherwise agreed in a custom licensing agreement with Jelurida B.V.,
 * no part of this software, including this file, may be copied, modified,
 * propagated, or distributed except according to the terms contained in the
 * LICENSE.txt file.
 *
 * Removal or modification of this copyright notice is prohibited.
 *
 */

package nxt.http;

import nxt.crypto.Crypto;
import nxt.util.Convert;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public final class PaperWalletServlet extends HttpServlet {

    /**
     * Return a the paper wallet Html page representation previously generated by the client.
     * This servlet is invoked internally from the JavaScriptBridge class.
     * To prevent external requests from stealing the paper wallet, the caller must send as parameter the hash
     * of the paper wallet it wants to receive. This ensures that you can only download the wallet page if you
     * already have it, i.e. if you generated it.
     * @param req the request
     * @param resp the response
     * @throws IOException the exception
     */
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String paperWalletPage = API.getPaperWalletPage();
        if (paperWalletPage == null) {
            resp.sendError(404);
            return;
        }
        byte[] hash = Crypto.sha256().digest(paperWalletPage.getBytes(StandardCharsets.UTF_8));
        if (!Convert.toHexString(hash).equals(req.getParameter("hash"))) {
            resp.sendError(403);
            return;
        }
        resp.getWriter().append(paperWalletPage);
        resp.getWriter().close();
    }
}
